/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.privileged.transaction.xa.IllegalTransactionStateException;

public class ValidateTransactionalStateInterceptor<T>
implements ExecutionInterceptor<T> {
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;
    private boolean isCompatibility;

    public ValidateTransactionalStateInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig, boolean isCompatibility) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.isCompatibility = isCompatibility;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (this.transactionConfig.getAction() == 5 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Never"));
        }
        if (this.transactionConfig.getAction() == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        if (!this.isCompatibility && this.transactionConfig.getAction() == 1 && tx != null && !tx.isXA()) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Always Begin").setNextMessage(I18nMessageFactory.createStaticMessage("Non-XA transactions can't be nested.")));
        }
        return this.next.execute(callback, executionContext);
    }
}

