/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PolicyTraceLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyTraceLogger.class);
    private static final String NL = System.lineSeparator();
    private static final String TAB = "   ";

    PolicyTraceLogger() {
    }

    public void logSourcePolicyStart(Policy policy, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            PrivilegedEvent.setCurrentEvent((PrivilegedEvent)event);
            LOGGER.trace(NL + "Executing policy " + this.getPolicyName(policy) + NL + this.eventAsString(event));
        }
    }

    public void logBeforeExecuteNext(String policyId, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            this.logEvent(NL + "Jumping to next from policy " + policyId, event);
        }
    }

    public void logAfterExecuteNext(String policyId, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            this.logEvent(NL + "Resuming execution of policy " + policyId, event);
        }
    }

    public void logOperationPolicyStart(Policy policy, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            this.logEvent(NL + "Executing operation policy " + this.getPolicyName(policy), event);
        }
    }

    public void logSourcePolicyEnd(Policy policy, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            this.logEvent(NL + "Policy " + this.getPolicyName(policy) + " execution finished", event);
        }
    }

    public void logOperationPolicyEnd(Policy policy, CoreEvent event) {
        if (LOGGER.isTraceEnabled()) {
            this.logEvent(NL + "Operation policy " + this.getPolicyName(policy) + " execution finished", event);
        }
    }

    public void logSourcePolicyFailureResult(SourcePolicyFailureResult result) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event id: " + result.getMessagingException().getEvent().getContext().getId() + "\nFinished processing with failure. \nError message: " + result.getMessagingException().getMessage());
        }
    }

    private void logEvent(String initialLine, CoreEvent event) {
        LOGGER.trace(initialLine + NL + this.eventAsString(event));
    }

    private String eventAsString(CoreEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append("Attributes: ").append(this.attributesAsString(event)).append(NL).append("Variables: ").append(this.variablesAsString(event.getVariables()));
        event.getAuthentication().ifPresent(authentication -> builder.append(NL).append("Authentication: ").append(event.getAuthentication()));
        return builder.toString();
    }

    private String attributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private String variablesAsString(Map<String, TypedValue<?>> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!variables.isEmpty()) {
            builder.append(NL);
        }
        variables.entrySet().forEach(variable -> builder.append(TAB).append(variable).append(NL));
        builder.append("}");
        return builder.toString();
    }

    private String getPolicyName(Policy policy) {
        return policy.getPolicyId();
    }
}

