/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.AbstractProcessor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceProcessor
extends AbstractProcessor
implements InterceptingMessageProcessor,
MuleContextAware,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceProcessor.class);
    private final Processor referencedProcessor;
    private MuleContext muleContext;

    public ReferenceProcessor(Processor processor) {
        this.referencedProcessor = processor;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return this.referencedProcessor.process(event);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return this.referencedProcessor.apply(publisher);
    }

    public Processor getReferencedProcessor() {
        return this.referencedProcessor;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.referencedProcessor);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.referencedProcessor, logger);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.referencedProcessor);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.referencedProcessor, this.muleContext);
    }

    @Override
    public void setListener(Processor listener) {
        if (!(this.referencedProcessor instanceof InterceptingMessageProcessor)) {
            throw new IllegalStateException("setListener call not expected since the referenced message processor is not intercepting");
        }
        ((InterceptingMessageProcessor)this.referencedProcessor).setListener(listener);
    }
}

