/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class InterceptedReactiveProcessor
implements ReactiveProcessor {
    private final ReactiveProcessor processor;
    private final ReactiveProcessor next;
    private final ReactiveProcessor.ProcessingType processingType;

    public InterceptedReactiveProcessor(ReactiveProcessor processor, ReactiveProcessor next) {
        this.processor = processor;
        this.processingType = processor.getProcessingType();
        this.next = next;
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPublisher) {
        Flux flux = Flux.from(eventPublisher);
        if (this.processor instanceof Component && ((Component)((Object)this.processor)).getLocation() != null) {
            flux = flux.checkpoint(((Component)((Object)this.processor)).getLocation().getLocation());
        }
        return flux.transform((Function)this.next);
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        return this.processingType;
    }

    public ReactiveProcessor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return this.processor instanceof Component ? ((Component)((Object)this.processor)).getLocation().getLocation() : this.processor.toString();
    }
}

