/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import java.util.Set;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.simple.AbstractRemoveVariablePropertyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFlowVariableProcessor
extends AbstractRemoveVariablePropertyProcessor {
    private static final String FLOW_VAR_NAME = "flow variables";
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveFlowVariableProcessor.class);

    @Override
    protected Set<String> getPropertyNames(PrivilegedEvent event) {
        return event.getVariables().keySet();
    }

    @Override
    protected PrivilegedEvent removeProperty(PrivilegedEvent event, String propertyName) {
        if (event.getVariables().containsKey(propertyName)) {
            return PrivilegedEvent.builder(event).removeVariable(propertyName).build();
        }
        LOGGER.warn("There is no variable named '{}'. Check the 'variableName' parameter in the 'remove-variable' component at {}", (Object)propertyName, (Object)this.getLocation().getLocation());
        return event;
    }

    @Override
    protected String getScopeName() {
        return FLOW_VAR_NAME;
    }
}

