/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.enricher;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.ComponentInnerProcessor;
import org.mule.runtime.core.internal.processor.strategy.enricher.ReactiveProcessorEnricher;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ComponentProcessingStrategyReactiveProcessorBuilder;
import org.mule.runtime.core.internal.profiling.ReactorAwareProfilingService;

public class ProactorProcessingStrategyEnricher
implements ReactiveProcessorEnricher {
    private final int maxConcurrency;
    private final int parallelism;
    private final int subscribers;
    private final Supplier<Scheduler> contextSchedulerSupplier;
    private final Function<ScheduledExecutorService, ScheduledExecutorService> schedulerDecorator;
    private final ReactorAwareProfilingService profilingService;
    private final String artifactId;
    private final String artifactType;

    public ProactorProcessingStrategyEnricher(Supplier<Scheduler> contextSchedulerSupplier, Function<ScheduledExecutorService, ScheduledExecutorService> schedulerDecorator, ReactorAwareProfilingService profilingService, String artifactId, String artifactType, int maxConcurrency, int parallelism, int subscribers) {
        this.schedulerDecorator = schedulerDecorator;
        this.profilingService = profilingService;
        this.maxConcurrency = maxConcurrency;
        this.parallelism = parallelism;
        this.subscribers = subscribers;
        this.contextSchedulerSupplier = contextSchedulerSupplier;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    @Override
    public ReactiveProcessor enrich(ReactiveProcessor processor) {
        return ComponentProcessingStrategyReactiveProcessorBuilder.processingStrategyReactiveProcessorFrom(processor, this.contextSchedulerSupplier.get(), this.artifactId, this.artifactType).withDispatcherScheduler(this.schedulerDecorator.apply(this.contextSchedulerSupplier.get())).withProfilingService(this.profilingService).withParallelism(this.getChainParallelism(processor)).build();
    }

    private int getChainParallelism(ReactiveProcessor processor) {
        if (this.maxConcurrency == 1) {
            return 1;
        }
        if (this.maxConcurrency == Integer.MAX_VALUE) {
            if (processor instanceof ComponentInnerProcessor && !((ComponentInnerProcessor)processor).isBlocking()) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }
        return Math.max(this.maxConcurrency / (this.parallelism * this.subscribers), 1);
    }
}

