/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.ProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.profiling.DefaultProfilingNotificationListener;
import org.mule.runtime.core.internal.profiling.ReactorAwareProfilingService;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.mule.runtime.core.internal.profiling.notification.ProfilingNotification;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public abstract class AbstractProfilingService
implements ReactorAwareProfilingService,
PrivilegedProfilingService,
Initialisable,
Startable,
Stoppable {
    @Inject
    protected ServerNotificationManager notificationManager;
    @Inject
    protected ProfilingFeatureFlaggingService featureFlaggingService;
    @Inject
    protected MuleContext muleContext;
    private final Set<NotificationListener<?>> addedListeners = new HashSet();

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void start() throws MuleException {
        this.registerDataConsumers(this.getDiscoveryStrategy().discover());
    }

    private void registerDataConsumers(Set<ProfilingDataConsumer<?>> dataConsumers) {
        for (ProfilingDataConsumer<?> dataConsumer : dataConsumers) {
            this.doRegisterConsumer(dataConsumer);
        }
        this.registerNotificationListeners(dataConsumers);
        this.onDataConsumersRegistered();
    }

    private void doRegisterConsumer(ProfilingDataConsumer<?> dataConsumer) {
        Set<ProfilingEventType<?>> profilingEventTypes = dataConsumer.getProfilingEventTypes();
        for (ProfilingEventType<?> profilingEventType : profilingEventTypes) {
            this.featureFlaggingService.registerProfilingFeature(profilingEventType, dataConsumer.getClass().getName());
            if (!this.featureFlaggingService.isEnabled(MuleRuntimeFeature.FORCE_RUNTIME_PROFILING_CONSUMERS_ENABLEMENT)) continue;
            this.featureFlaggingService.toggleProfilingFeature(profilingEventType, dataConsumer.getClass().getName(), this.isInternalDataConsumer(dataConsumer));
        }
    }

    private boolean isInternalDataConsumer(ProfilingDataConsumer<?> dataConsumer) {
        return dataConsumer.getClass().isAnnotationPresent(RuntimeInternalProfilingDataConsumer.class);
    }

    protected abstract void onDataConsumersRegistered();

    private void registerNotificationListeners(Set<ProfilingDataConsumer<?>> profilingDataConsumers) {
        profilingDataConsumers.forEach(this::registerNotificationListener);
    }

    private <T extends ProfilingEventContext> void registerNotificationListener(ProfilingDataConsumer<T> profilingDataConsumer) {
        DefaultProfilingNotificationListener<T> profilingNotificationListener = new DefaultProfilingNotificationListener<T>(profilingDataConsumer);
        this.notificationManager.addListenerSubscription(profilingNotificationListener, pn -> this.filterByAction(profilingDataConsumer, (ProfilingNotification)pn));
        this.addedListeners.add(profilingNotificationListener);
    }

    private <T extends ProfilingEventContext> boolean filterByAction(ProfilingDataConsumer<T> profilingDataConsumer, ProfilingNotification<T> profilingNotification) {
        return profilingDataConsumer.getProfilingEventTypes().stream().anyMatch(eventType -> ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(eventType).equalsIgnoreCase(profilingNotification.getActionName())) && profilingDataConsumer.getEventContextFilter().test((ProfilingEventContext)profilingNotification.getSource());
    }

    @Override
    public void stop() {
        if (!this.notificationManager.isDisposed()) {
            this.addedListeners.forEach(listener -> this.notificationManager.removeListener((NotificationListener<?>)listener));
        }
    }

    protected abstract ProfilingDataConsumerDiscoveryStrategy getDiscoveryStrategy();

    public <T extends ProfilingEventContext> void notifyEvent(T profilingEventContext, ProfilingEventType<T> action) {
        this.notificationManager.fireNotification(new ProfilingNotification<T>(profilingEventContext, action));
    }

    public static void configureEnableProfilingService() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE.getSince())).isPresent());
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.FORCE_RUNTIME_PROFILING_CONSUMERS_ENABLEMENT, featureContext -> false);
    }

    @Override
    public <T extends ProfilingEventContext> void registerProfilingDataConsumer(ProfilingDataConsumer<T> profilingDataConsumer) {
        this.doRegisterConsumer(profilingDataConsumer);
        this.registerNotificationListener(profilingDataConsumer);
        this.onDataConsumersRegistered();
    }
}

