/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class LocalDateToDate
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public LocalDateToDate() {
        this.registerSourceType(DataType.fromType(LocalDate.class));
        this.registerSourceType(DataType.fromType(LocalDateTime.class));
        this.setReturnDataType(DataType.fromType(Date.class));
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        if (src instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)src).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (src instanceof LocalDate) {
            return Date.from(((LocalDate)src).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage("Unexpected input type: " + src.getClass().getName()));
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
        this.priorityWeighting = weighting;
    }
}

