/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.collection;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ListIteratorAdapter<T>
implements ListIterator<T> {
    private final List<T> delegate;
    private final int size;
    private int index;
    private int lastIndex = 0;

    public ListIteratorAdapter(List<T> delegate) {
        this(delegate, 0);
    }

    ListIteratorAdapter(List<T> delegate, int startIndex) {
        this.delegate = delegate;
        this.index = startIndex;
        this.size = delegate.size();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public T next() {
        this.lastIndex = this.index++;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public T previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        this.lastIndex = this.index - 1;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public int nextIndex() {
        return this.index < this.size ? this.index : this.size;
    }

    @Override
    public int previousIndex() {
        return this.index > 0 ? this.index - 1 : -1;
    }

    @Override
    public void remove() {
        this.delegate.remove(this.lastIndex);
    }

    @Override
    public void set(T item) {
        this.delegate.set(this.lastIndex, item);
    }

    @Override
    public void add(T item) {
        this.delegate.add(this.index, item);
    }
}

