/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;

public class MessageRedeliveredException
extends MuleException
implements ComposedErrorException {
    private static final long serialVersionUID = 9013890402770563933L;
    private final String messageId;
    private final List<Error> errors;
    private final int redeliveryCount;
    private final int maxRedelivery;

    protected MessageRedeliveredException(String messageId, List<Error> errors, int redeliveryCount, int maxRedelivery, I18nMessage message, Throwable cause) {
        super(message, cause);
        this.messageId = messageId;
        this.errors = errors;
        this.redeliveryCount = redeliveryCount;
        this.maxRedelivery = maxRedelivery;
    }

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery, Throwable cause) {
        this(messageId, Collections.emptyList(), redeliveryCount, maxRedelivery, I18nMessageFactory.createStaticMessage("%s caught while handling redelivery: %s", cause.getClass().getName(), cause.getMessage()), cause);
    }

    public MessageRedeliveredException(String messageId, int redeliveryCount, int maxRedelivery) {
        this(messageId, Collections.emptyList(), redeliveryCount, maxRedelivery, I18nMessageFactory.createStaticMessage("Maximum redelivery attempts reached"), null);
    }

    public MessageRedeliveredException(String messageId, List<Error> errors, int redeliveryCount, int maxRedelivery) {
        this(messageId, errors, redeliveryCount, maxRedelivery, I18nMessageFactory.createStaticMessage("Maximum redelivery attempts reached. Last error was %s.", ((Error)Iterables.getLast(errors)).getErrorType().toString()), null);
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public List<Error> getErrors() {
        return this.errors;
    }

    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }
}

