/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;

public class MuleApplicationClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<ApplicationDescriptor> {
    private final NativeLibraryFinderFactory nativeLibraryFinderFactory;

    public MuleApplicationClassLoaderFactory(NativeLibraryFinderFactory nativeLibraryFinderFactory) {
        Preconditions.checkArgument(nativeLibraryFinderFactory != null, "nativeLibraryFinderFactory cannot be null");
        this.nativeLibraryFinderFactory = nativeLibraryFinderFactory;
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ApplicationDescriptor descriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        ClassLoaderLookupPolicy classLoaderLookupPolicy = this.getApplicationClassLoaderLookupPolicy(parent, descriptor);
        return new MuleApplicationClassLoader(artifactId, descriptor, parent.getClassLoader(), this.nativeLibraryFinderFactory.create(descriptor.getDataFolderName(), descriptor.getLoadedNativeLibrariesFolderName(), descriptor.getClassLoaderModel().getUrls()), Arrays.asList(descriptor.getClassLoaderModel().getUrls()), classLoaderLookupPolicy, artifactPluginClassLoaders);
    }

    private ClassLoaderLookupPolicy getApplicationClassLoaderLookupPolicy(ArtifactClassLoader parent, ApplicationDescriptor descriptor) {
        HashMap<String, LookupStrategy> pluginsLookupStrategies = new HashMap<String, LookupStrategy>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(p -> pluginsLookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parent.getClassLoaderLookupPolicy().extend(pluginsLookupStrategies);
    }
}

