/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import java.util.ArrayList;
import java.util.List;
import org.mule.apache.xerces.xni.XNIException;
import org.mule.apache.xerces.xni.parser.XMLParseException;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGathererErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXmlGathererErrorHandler
implements XmlGathererErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXmlGathererErrorHandler.class);
    private List<XMLParseException> errors = new ArrayList<XMLParseException>();

    @Override
    public void warning(String domain, String key, XMLParseException e) throws XNIException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found warning parsing domain: %s, key: %s", domain, key), (Throwable)e);
        }
    }

    @Override
    public void error(String domain, String key, XMLParseException e) throws XNIException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found error parsing domain: %s, key: %s", domain, key), (Throwable)e);
        }
        this.errors.add(e);
    }

    @Override
    public void fatalError(String domain, String key, XMLParseException e) throws XNIException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found fatal error parsing domain: %s, key: %s", domain, key), (Throwable)e);
        }
        throw e;
    }

    @Override
    public List<XMLParseException> getErrors() {
        return this.errors;
    }
}

