/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.AbstractNamedImmutableModel;

public final class ImmutableParameterModel
extends AbstractNamedImmutableModel
implements ParameterModel {
    private final MetadataType type;
    private final boolean hasDynamicType;
    private final boolean required;
    private final boolean isConfigOverride;
    private final boolean isComponentId;
    private final ValueProviderModel valueProviderModel;
    private List<FieldValueProviderModel> fieldValueProviderModels;
    private final ExpressionSupport expressionSupport;
    private final Object defaultValue;
    private final ParameterRole role;
    private final ParameterDslConfiguration dslConfiguration;
    private final LayoutModel layoutModel;
    private final List<StereotypeModel> allowedStereotypeModels;
    private final DeprecationModel deprecationModel;
    private Set<String> semanticTerms;

    @Deprecated
    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypeModels, Set<ModelProperty> modelProperties) {
        this(name, description, type, hasDynamicType, required, isConfigOverride, false, expressionSupport, defaultValue, role, dslConfiguration, displayModel, layoutModel, valueProviderModel, allowedStereotypeModels, modelProperties);
    }

    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypeModels, Set<ModelProperty> modelProperties) {
        this(name, description, type, hasDynamicType, required, isConfigOverride, isComponentId, expressionSupport, defaultValue, role, dslConfiguration, displayModel, layoutModel, valueProviderModel, allowedStereotypeModels, modelProperties, null);
    }

    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypeModels, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, type, hasDynamicType, required, isConfigOverride, isComponentId, expressionSupport, defaultValue, role, dslConfiguration, displayModel, layoutModel, valueProviderModel, allowedStereotypeModels, modelProperties, deprecationModel, null, Collections.emptyList());
    }

    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypeModels, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, Set<String> semanticTerms, List<FieldValueProviderModel> fieldValueProviderModels) {
        super(name, description, displayModel, modelProperties);
        this.type = type;
        this.required = required;
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.hasDynamicType = hasDynamicType;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.isConfigOverride = isConfigOverride;
        this.isComponentId = isComponentId;
        this.valueProviderModel = valueProviderModel;
        this.allowedStereotypeModels = Collections.unmodifiableList(allowedStereotypeModels);
        this.deprecationModel = deprecationModel;
        this.semanticTerms = semanticTerms != null ? Collections.unmodifiableSet(semanticTerms) : Collections.emptySet();
        this.fieldValueProviderModels = Collections.unmodifiableList(fieldValueProviderModels);
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    @Override
    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    @Override
    public ParameterRole getRole() {
        return this.role;
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    @Override
    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypeModels;
    }

    @Override
    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }

    @Override
    public List<FieldValueProviderModel> getFieldValueProviderModels() {
        if (this.fieldValueProviderModels == null) {
            this.fieldValueProviderModels = Collections.emptyList();
        }
        return this.fieldValueProviderModels;
    }

    @Override
    public boolean isComponentId() {
        return this.isComponentId;
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.ofNullable(this.deprecationModel);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecationModel != null;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return this.semanticTerms;
    }

    @Override
    public String toString() {
        return this.getName() + " {\n type=" + this.type + ",\n hasDynamicType=" + this.hasDynamicType + ",\n required=" + this.required + ",\n isConfigOverride=" + this.isConfigOverride + ",\n isComponentId=" + this.isComponentId + ",\n expressionSupport=" + (Object)((Object)this.expressionSupport) + ",\n defaultValue=" + this.defaultValue + ",\n role=" + (Object)((Object)this.role) + ",\n allowedStereotypeModels=" + this.allowedStereotypeModels + ",\n description='" + this.description + '\'' + ",\n semanticTerms ='" + this.semanticTerms + '\'' + "\n}";
    }
}

