/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Comparator;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;

public class LayoutOrderComparator {
    public static final Comparator<ObjectFieldType> OBJECTS_FIELDS_BY_LAYOUT_ORDER = new LayoutOrderObjectFieldsComparator();
    public static final Comparator<ParameterModel> PARAMETER_MODEL_BY_LAYOUT_ORDER = new LayoutOrderParameterModelComparator();

    private LayoutOrderComparator() {
    }

    private static class LayoutOrderParameterModelComparator
    implements Comparator<ParameterModel> {
        private LayoutOrderParameterModelComparator() {
        }

        @Override
        public int compare(ParameterModel p1, ParameterModel p2) {
            return p1.getLayoutModel().flatMap(LayoutModel::getOrder).orElse(-1) - p2.getLayoutModel().flatMap(LayoutModel::getOrder).orElse(-1);
        }
    }

    private static class LayoutOrderObjectFieldsComparator
    implements Comparator<ObjectFieldType> {
        private LayoutOrderObjectFieldsComparator() {
        }

        @Override
        public int compare(ObjectFieldType o1, ObjectFieldType o2) {
            return o1.getAnnotation(LayoutTypeAnnotation.class).flatMap(LayoutTypeAnnotation::getOrder).orElse(-1) - o2.getAnnotation(LayoutTypeAnnotation.class).flatMap(LayoutTypeAnnotation::getOrder).orElse(-1);
        }
    }
}

