/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.ocs.PlatformManagedOAuthUtils;

public class OAuthDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(final ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        final HashSet visitedOwners = new HashSet();
        final HashSet visitedProviders = new HashSet();
        final Reference<Object> ocsConnectionProvider = new Reference<Object>(null);
        final boolean ocsEnabled = PlatformManagedOAuthUtils.isPlatformManagedOAuthEnabled();
        new DeclarationWalker(){

            @Override
            protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                declaration.getModelProperty(OAuthModelProperty.class).ifPresent(property -> {
                    if (visitedProviders.add(System.identityHashCode(declaration))) {
                        new PropertiesEnricher(declaration, property.getGrantTypes()).enrich();
                    }
                    if (visitedOwners.add(System.identityHashCode(owner)) && ocsEnabled) {
                        this.addOCSConnectionProvider(owner, extensionLoadingContext);
                    }
                });
            }

            private void addOCSConnectionProvider(ConnectedDeclaration owner, ExtensionLoadingContext context) {
                if (ocsConnectionProvider.get() == null) {
                    ConnectionProviderDeclarer declarer = context.getExtensionDeclarer().withConnectionProvider(owner, "platformManagedOauth");
                    ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
                    ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)declarer.withConnectionManagementType(ConnectionManagementType.CACHED).supportsConnectivityTesting(true).withSemanticTerm("connectivity.PlatformManagedOAuthConnection").withModelProperty(new SyntheticModelModelProperty()).withModelProperty(new OAuthModelProperty(Collections.singletonList(new PlatformManagedOAuthGrantType()))).describedAs("Connect through a connection defined and managed in the Anypoint Platform").onDefaultParameterGroup().withRequiredParameter("connectionId").describedAs("The ID of the connection definition in the Anypoint Platform")).ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withRole(ParameterRole.BEHAVIOUR)).withSemanticTerm("connectivity.connectionId")).withDisplayModel(DisplayModel.builder().displayName("Connection ID").example("ocs:348573-495273958273-924852945/salesforce/john-sfdc-1k87kmjt").summary("The ID of the connection definition in the Anypoint Platform").build());
                    ocsConnectionProvider.set(declarer.getDeclaration());
                } else {
                    owner.addConnectionProvider((ConnectionProviderDeclaration)ocsConnectionProvider.get());
                }
            }
        }.walk(extensionDeclaration);
    }

    private class PropertiesEnricher
    implements OAuthGrantTypeVisitor {
        private final ConnectionProviderDeclaration declaration;
        private final List<OAuthGrantType> grantTypes;
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        private final MetadataType stringType = this.typeLoader.load((Type)((Object)String.class));

        private PropertiesEnricher(ConnectionProviderDeclaration declaration, List<OAuthGrantType> grantTypes) {
            this.declaration = declaration;
            this.grantTypes = grantTypes;
        }

        private void enrich() {
            this.grantTypes.forEach(type -> type.accept(this));
        }

        @Override
        public void visit(AuthorizationCodeGrantType grantType) {
            this.declaration.addSemanticTerm("connectivity.OAuthAuthorizationCodeConnection");
            this.addOAuthAuthorizationCodeParameters(this.declaration, grantType);
            this.addOAuthCallbackParameters(this.declaration);
            this.addOAuthStoreConfigParameter(this.declaration);
        }

        @Override
        public void visit(ClientCredentialsGrantType grantType) {
            this.declaration.addSemanticTerm("connectivity.OAuthClientCredentialsConnection");
            this.addOAuthClientCredentialsParameters(this.declaration, grantType);
            this.addOAuthStoreConfigParameter(this.declaration);
        }

        @Override
        public void visit(PlatformManagedOAuthGrantType grantType) {
        }

        private void addOAuthClientCredentialsParameters(ConnectionProviderDeclaration declaration, ClientCredentialsGrantType grantType) {
            LinkedList<ParameterDeclaration> params = new LinkedList<ParameterDeclaration>();
            params.add(this.buildParameter("clientId", "The OAuth client id as registered with the service provider", true, this.stringType, ExpressionSupport.SUPPORTED, null, "connectivity.clientId"));
            params.add(this.buildParameter("clientSecret", "The OAuth client secret as registered with the service provider", true, this.stringType, ExpressionSupport.SUPPORTED, null, "connectivity.clientSecret"));
            params.add(this.buildParameter("tokenUrl", "The service provider's token endpoint URL", false, this.stringType, ExpressionSupport.SUPPORTED, grantType.getTokenUrl(), "core.tokenUrlTemplate"));
            params.add(this.buildParameter("scopes", "The OAuth scopes to be requested during the dance. If not provided, it will default to those in the annotation", false, this.stringType, ExpressionSupport.SUPPORTED, grantType.getDefaultScopes().orElse(null), new String[0]));
            this.addToGroup(params, "oauthClientCredentials", "OAuth Client Credentials", declaration);
        }

        private void addOAuthAuthorizationCodeParameters(ConnectionProviderDeclaration declaration, AuthorizationCodeGrantType grantType) {
            LinkedList<ParameterDeclaration> params = new LinkedList<ParameterDeclaration>();
            params.add(this.buildParameter("consumerKey", "The OAuth consumerKey as registered with the service provider", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, "connectivity.clientId"));
            params.add(this.buildParameter("consumerSecret", "The OAuth consumerSecret as registered with the service provider", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, "connectivity.clientSecret"));
            params.add(this.buildParameter("authorizationUrl", "The service provider's authorization endpoint URL", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getAuthorizationUrl(), "authorizationUrl"));
            params.add(this.buildParameter("accessTokenUrl", "The service provider's accessToken endpoint URL", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getAccessTokenUrl(), "core.tokenUrlTemplate"));
            params.add(this.buildParameter("scopes", "The OAuth scopes to be requested during the dance. If not provided, it will default to those in the annotation", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, grantType.getDefaultScope().orElse(null), new String[0]));
            params.add(this.buildParameter("resourceOwnerId", "The resourceOwnerId which each component should use if it doesn't reference otherwise.", false, this.stringType, ExpressionSupport.SUPPORTED, null, "connectivity.clientId"));
            ParameterDeclaration beforeFlowParam = this.buildParameter("before", "The name of a flow to be executed right before starting the OAuth dance", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, new String[0]);
            beforeFlowParam.setAllowedStereotypeModels(Collections.singletonList(MuleStereotypes.FLOW));
            params.add(beforeFlowParam);
            ParameterDeclaration afterFlowParam = this.buildParameter("after", "The name of a flow to be executed right after an accessToken has been received", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, new String[0]);
            afterFlowParam.setAllowedStereotypeModels(Collections.singletonList(MuleStereotypes.FLOW));
            params.add(afterFlowParam);
            this.addToGroup(params, "oauthAuthorizationCode", "OAuth Authorization Code", declaration);
        }

        private void addOAuthCallbackParameters(ConnectionProviderDeclaration declaration) {
            LinkedList<ParameterDeclaration> params = new LinkedList<ParameterDeclaration>();
            ParameterDeclaration listenerConfig = this.buildParameter("listenerConfig", "A reference to a <http:listener-config /> to be used in order to create the listener that will catch the access token callback endpoint.", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, new String[0]);
            listenerConfig.setAllowedStereotypeModels(Collections.singletonList(StereotypeModelBuilder.newStereotype("LISTENER_CONFIG", "HTTP").withParent(MuleStereotypes.CONFIG).build()));
            params.add(listenerConfig);
            params.add(this.buildParameter("callbackPath", "The path of the access token callback endpoint", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, "apiContract.path"));
            params.add(this.buildParameter("authorizePath", "The path of the local http endpoint which triggers the OAuth dance", true, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, "apiContract.path"));
            params.add(this.buildParameter("externalCallbackUrl", "If the callback endpoint is behind a proxy or should be accessed through a non direct URL, use this parameter to tell the OAuth provider the URL it should use to access the callback", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, "core.urlTemplate"));
            this.addToGroup(params, "oauthCallbackConfig", "OAuth Callback Config", declaration);
        }

        private void addToGroup(List<ParameterDeclaration> params, String groupName, String displayGroupName, ConnectionProviderDeclaration declaration) {
            ParameterGroupDeclaration group = declaration.getParameterGroup(groupName);
            group.setDisplayModel(DisplayModel.builder().displayName(displayGroupName).build());
            params.forEach(group::addParameter);
            group.showInDsl(true);
        }

        private void addOAuthStoreConfigParameter(ConnectionProviderDeclaration declaration) {
            ParameterDeclaration osParameter = this.buildParameter("objectStore", "A reference to the object store that should be used to store each resource owner id's data. If not specified, runtime will automatically provision the default one.", false, this.stringType, ExpressionSupport.NOT_SUPPORTED, null, new String[0]);
            osParameter.setAllowedStereotypeModels(Collections.singletonList(MuleStereotypes.OBJECT_STORE));
            this.addToGroup(Arrays.asList(osParameter), "oauthStoreConfig", "OAuth Store Config", declaration);
        }

        private ParameterDeclaration buildParameter(String name, String description, boolean required, MetadataType type, ExpressionSupport expressionSupport, Object defaultValue, String ... semanticTerms) {
            ParameterDeclaration parameter = new ParameterDeclaration(name);
            parameter.setDescription(description);
            parameter.setExpressionSupport(expressionSupport);
            parameter.setRequired(required);
            parameter.setDefaultValue(defaultValue);
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(type, false);
            if (semanticTerms != null) {
                Arrays.stream(semanticTerms).forEach(parameter::addSemanticTerm);
            }
            return parameter;
        }
    }
}

