/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.property.TargetModelProperty;

public final class TargetParameterDeclarationEnricher
implements DeclarationEnricher {
    private static final Map<String, Set<String>> blocklistedExtensionsOperations = ImmutableMap.of((Object)"ee", (Object)ImmutableSet.of((Object)"transform"), (Object)"cxf", (Object)ImmutableSet.of((Object)"simpleService", (Object)"jaxwsService", (Object)"proxyService", (Object)"simpleClient", (Object)"jaxwsClient", (Object)"proxyClient", (Object[])new String[0]));

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        String extensionName = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName();
        Set blocklistedOperationsNames = blocklistedExtensionsOperations.getOrDefault(extensionName, Collections.emptySet());
        new EnricherDelegate(blocklistedOperationsNames).enrich(extensionLoadingContext);
    }

    private static void addTargetValueParameter(OperationDeclaration operationDeclaration, ParameterDeclaration targetValueParameter) {
        operationDeclaration.getParameterGroup("Output").addParameter(targetValueParameter);
    }

    private static void addTargetParameter(OperationDeclaration operationDeclaration, ParameterDeclaration targetParameter) {
        operationDeclaration.getParameterGroup("Output").addParameter(targetParameter);
    }

    private static boolean definesTargetValueParameter(OperationDeclaration operationDeclaration) {
        return operationDeclaration.getParameterGroup("Output").getParameters().stream().anyMatch(parameterDeclaration -> parameterDeclaration.getName().equals("targetValue"));
    }

    private static boolean definesTargetParameter(OperationDeclaration operationDeclaration) {
        return operationDeclaration.getParameterGroup("Output").getParameters().stream().anyMatch(parameterDeclaration -> parameterDeclaration.getName().equals("target"));
    }

    private static class EnricherDelegate
    implements DeclarationEnricher {
        private final Set<String> blocklistedOperationsNames;
        private final MetadataType attributeType;
        private final MetadataType targetValue;

        private EnricherDelegate(Set<String> blocklistedOperationsNames) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            this.attributeType = typeLoader.load((Type)((Object)String.class));
            this.targetValue = typeLoader.load((Type)((Object)String.class));
            this.blocklistedOperationsNames = blocklistedOperationsNames;
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            new IdempotentDeclarationWalker(){

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    if (blocklistedOperationsNames.contains(declaration.getName())) {
                        return;
                    }
                    MetadataType outputType = declaration.getOutput().getType();
                    if (outputType == null) {
                        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not specify an output type", declaration.getName()));
                    }
                    if (!(outputType instanceof VoidType)) {
                        this.enrichWithTargetParameterDeclaration(declaration);
                        this.enrichWithTargetValueParameterDeclaration(declaration);
                    }
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }

        private void enrichWithTargetParameterDeclaration(OperationDeclaration operationDeclaration) {
            if (!TargetParameterDeclarationEnricher.definesTargetParameter(operationDeclaration)) {
                ParameterDeclaration targetParameterDeclaration = new ParameterDeclaration("target");
                targetParameterDeclaration.setDescription("The name of a variable on which the operation's output will be placed");
                targetParameterDeclaration.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                targetParameterDeclaration.setRequired(false);
                targetParameterDeclaration.setParameterRole(ParameterRole.BEHAVIOUR);
                targetParameterDeclaration.setType(this.attributeType, false);
                targetParameterDeclaration.setDisplayModel(DisplayModel.builder().displayName("Target Variable").build());
                targetParameterDeclaration.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                TargetParameterDeclarationEnricher.addTargetParameter(operationDeclaration, targetParameterDeclaration);
            }
        }

        private void enrichWithTargetValueParameterDeclaration(OperationDeclaration operationDeclaration) {
            if (!TargetParameterDeclarationEnricher.definesTargetValueParameter(operationDeclaration)) {
                ParameterDeclaration targetValueParameterDeclaration = new ParameterDeclaration("targetValue");
                targetValueParameterDeclaration.setDescription("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable");
                targetValueParameterDeclaration.setExpressionSupport(ExpressionSupport.REQUIRED);
                targetValueParameterDeclaration.setRequired(false);
                targetValueParameterDeclaration.setDefaultValue("#[payload]");
                targetValueParameterDeclaration.setParameterRole(ParameterRole.BEHAVIOUR);
                targetValueParameterDeclaration.setType(this.targetValue, false);
                targetValueParameterDeclaration.setDisplayModel(DisplayModel.builder().displayName("Target Value").build());
                targetValueParameterDeclaration.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                targetValueParameterDeclaration.addModelProperty(new TargetModelProperty());
                TargetParameterDeclarationEnricher.addTargetValueParameter(operationDeclaration, targetValueParameterDeclaration);
            }
        }
    }
}

