/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.Descriptable;

public class ComponentMetadataTypesDescriptorResult
implements Descriptable<MetadataResult<ComponentMetadataTypesDescriptor>> {
    private Map<String, MetadataType> inputMetadata = new HashMap<String, MetadataType>();
    private MetadataType outputMetadata;
    private MetadataType outputAttributesMetadata;
    private List<MetadataFailure> failures;

    public ComponentMetadataTypesDescriptorResult(MetadataResult<ComponentMetadataTypesDescriptor> result) {
        ComponentMetadataTypesDescriptor descriptor = result.get();
        if (descriptor != null) {
            this.inputMetadata = descriptor.getInputMetadata();
            this.outputMetadata = descriptor.getOutputMetadata().orElse(null);
            this.outputAttributesMetadata = descriptor.getOutputAttributesMetadata().orElse(null);
        }
        this.failures = result.getFailures();
    }

    public Map<String, MetadataType> getInputMetadata() {
        return this.inputMetadata;
    }

    public MetadataType getOutputMetadata() {
        return this.outputMetadata;
    }

    public MetadataType getOutputAttributesMetadata() {
        return this.outputAttributesMetadata;
    }

    public List<MetadataFailure> getFailures() {
        return this.failures;
    }

    @Override
    public MetadataResult<ComponentMetadataTypesDescriptor> toDescriptor() {
        return this.failures.isEmpty() ? MetadataResult.success(new ComponentMetadataTypesDescriptor(this.inputMetadata, this.outputMetadata, this.outputAttributesMetadata)) : MetadataResult.failure(this.failures);
    }
}

