/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.extension.api.model.notification.NotificationModelBuilder;
import org.mule.runtime.extension.internal.persistence.NotificationModelToIdentifierSerializer;

class NotificationModelSerializerDelegate {
    private static final String NOTIFICATION = "notification";
    private static final String METADATA_TYPE = "metadataType";
    private Map<String, NotificationModel> notificationModelRespository;
    private Gson gson;

    NotificationModelSerializerDelegate(Map<String, NotificationModel> notificationModelRespository, Gson gson) {
        this.notificationModelRespository = notificationModelRespository;
        this.gson = gson;
    }

    void writeNotifications(Set<NotificationModel> notificationModels, JsonWriter out) throws IOException {
        TypeAdapter metadataTypeTypeAdapter = this.gson.getAdapter(MetadataType.class);
        out.name("notifications");
        out.beginArray();
        for (NotificationModel notificationModel : notificationModels) {
            this.writeNotification(out, notificationModel, (TypeAdapter<MetadataType>)metadataTypeTypeAdapter);
        }
        out.endArray();
    }

    private void writeNotification(JsonWriter out, NotificationModel notificationModel, TypeAdapter<MetadataType> metadataTypeTypeAdapter) throws IOException {
        out.beginObject();
        out.name(NOTIFICATION).value(NotificationModelToIdentifierSerializer.serialize(notificationModel));
        out.name(METADATA_TYPE);
        metadataTypeTypeAdapter.write(out, (Object)notificationModel.getType());
        out.endObject();
    }

    Map<String, NotificationModel> parseNotifications(JsonArray notifications) {
        notifications.iterator().forEachRemaining(element -> {
            JsonObject notification = element.getAsJsonObject();
            String aNotification = notification.get(NOTIFICATION).getAsString();
            MetadataType metadataType = (MetadataType)this.gson.fromJson(notification.get(METADATA_TYPE), MetadataType.class);
            this.notificationModelRespository.put(aNotification, NotificationModelBuilder.newNotification(ComponentIdentifier.buildFromStringRepresentation(aNotification)).withType(metadataType).build());
        });
        return this.notificationModelRespository;
    }
}

