/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.runtime.api.meta.model.SubTypesModel;

public class SubTypesModelTypeAdapter
extends TypeAdapter<SubTypesModel> {
    public static final String SUB_TYPES = "subTypes";
    private static final String BASE_TYPE = "baseType";
    private final MetadataTypeGsonTypeAdapter typeAdapter;

    public SubTypesModelTypeAdapter(ObjectTypeReferenceHandler referenceHandler) {
        this.typeAdapter = new MetadataTypeGsonTypeAdapter(referenceHandler);
    }

    public void write(JsonWriter out, SubTypesModel value) throws IOException {
        out.beginObject();
        out.name(BASE_TYPE);
        this.typeAdapter.write(out, value.getBaseType());
        out.name(SUB_TYPES);
        out.beginArray();
        for (MetadataType metadataType : value.getSubTypes()) {
            this.typeAdapter.write(out, metadataType);
        }
        out.endArray();
        out.endObject();
    }

    public SubTypesModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        MetadataType baseType = (MetadataType)this.typeAdapter.fromJsonTree(json.get(BASE_TYPE));
        LinkedHashSet<MetadataType> subTypes = new LinkedHashSet<MetadataType>();
        json.get(SUB_TYPES).getAsJsonArray().forEach(subTypeElement -> subTypes.add((MetadataType)this.typeAdapter.fromJsonTree((JsonElement)subTypeElement)));
        return new SubTypesModel(baseType, subTypes);
    }
}

