/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.descriptor;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;

public class VersionFormatArtifactDescriptorValidator
implements ArtifactDescriptorValidator {
    private boolean doNotFailIfBundleDescriptorNotPresent;

    public VersionFormatArtifactDescriptorValidator(boolean doNotFailIfBundleDescriptorNotPresent) {
        this.doNotFailIfBundleDescriptorNotPresent = doNotFailIfBundleDescriptorNotPresent;
    }

    @Override
    public void validate(ArtifactDescriptor descriptor) {
        if (this.doNotFailIfBundleDescriptorNotPresent && descriptor.getBundleDescriptor() == null) {
            return;
        }
        this.doValidate(descriptor);
    }

    private void doValidate(ArtifactDescriptor descriptor) {
        String bundleDescriptorVersion = descriptor.getBundleDescriptor().getVersion();
        Preconditions.checkState(bundleDescriptorVersion != null, String.format("No version specified in the bundle descriptor of the artifact %s", descriptor.getName()));
        MuleVersion artifactVersion = new MuleVersion(bundleDescriptorVersion);
        Preconditions.checkState(artifactVersion.getRevision() != -1, String.format("Artifact %s version %s must contain a revision number. The version format must be x.y.z and the z part is missing", descriptor.getName(), artifactVersion));
    }
}

