/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;

public class ApplicationStatusMapper {
    private static final Map<String, ApplicationStatus> statusMapping = ApplicationStatusMapper.getStatusMapping();

    public static ApplicationStatus getApplicationStatus(String currentPhase) {
        ApplicationStatus applicationStatus = statusMapping.get(currentPhase);
        if (applicationStatus == null) {
            throw new IllegalStateException("Unknown lifecycle phase: " + currentPhase);
        }
        return applicationStatus;
    }

    private static Map<String, ApplicationStatus> getStatusMapping() {
        SmallMap<String, ApplicationStatus> statusMapping = SmallMap.of("not in lifecycle", ApplicationStatus.CREATED, "dispose", ApplicationStatus.DESTROYED, "stop", ApplicationStatus.STOPPED, "start", ApplicationStatus.STARTED, "initialise", ApplicationStatus.INITIALISED);
        return statusMapping;
    }
}

