/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public class ContainerServicesMuleContextConfigurator
implements ServiceConfigurator {
    private final ServiceRepository serviceRepository;

    public ContainerServicesMuleContextConfigurator(ServiceRepository serviceRepository) {
        Preconditions.checkArgument(serviceRepository != null, "serviceRepository cannot be null");
        this.serviceRepository = serviceRepository;
    }

    @Override
    public void configure(CustomizationService customizationService) {
        this.serviceRepository.getServices().forEach(service -> {
            String name = service.getName();
            String contract = service.getContractName();
            if (!StringUtils.isEmpty(contract)) {
                name = name + " - " + contract;
            }
            customizationService.registerCustomServiceImpl(name, service);
        });
    }
}

