/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.OperationDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ParameterDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.SourcesDescriptionDocumenter;

final class ConfigurationDescriptionDocumenter
extends AbstractDescriptionDocumenter {
    private final ParameterDescriptionDocumenter parameterDeclarer;
    private final OperationDescriptionDocumenter operationDeclarer;
    private final SourcesDescriptionDocumenter sourceDeclarer;

    ConfigurationDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.parameterDeclarer = new ParameterDescriptionDocumenter(processingEnv);
        this.operationDeclarer = new OperationDescriptionDocumenter(processingEnv);
        this.sourceDeclarer = new SourcesDescriptionDocumenter(processingEnv);
    }

    void document(ExtensionDeclaration extensionDeclaration, ConfigurationDeclaration declaration, TypeElement configElement) {
        declaration.setDescription(processor.getJavaDocSummary(this.processingEnv, configElement));
        this.operationDeclarer.document(configElement, declaration, extensionDeclaration);
        this.sourceDeclarer.document(configElement, declaration, extensionDeclaration);
        this.documentConnectionProviders(declaration, configElement);
        this.parameterDeclarer.document(declaration, configElement);
    }

    public void documentConnectionProviders(ConnectedDeclaration<?> declaration, TypeElement element) {
        this.getConnectionProviderClasses(this.processingEnv, element).forEach(providerElement -> this.findMatchingProvider(declaration, (Element)providerElement).ifPresent(provider -> {
            provider.setDescription(processor.getJavaDocSummary(this.processingEnv, (Element)providerElement));
            this.parameterDeclarer.document((ParameterizedDeclaration<?>)provider, (TypeElement)providerElement);
        }));
    }

    private Optional<ConnectionProviderDeclaration> findMatchingProvider(ConnectedDeclaration<?> declaration, Element element) {
        Optional<String> alias = this.getAlias(element);
        String defaultNaming = NameUtils.hyphenize(element.getSimpleName().toString().replace("Provider", ""));
        return declaration.getConnectionProviders().stream().filter(provider -> {
            String name = provider.getName();
            if (alias.isPresent()) {
                return name.equals(alias.get());
            }
            return name.equals(defaultNaming) || name.equals("connection");
        }).findAny();
    }

    private List<TypeElement> getConnectionProviderClasses(ProcessingEnvironment processingEnv, TypeElement element) {
        return processor.getArrayClassAnnotationValue(element, ConnectionProviders.class, "value", processingEnv);
    }
}

