/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.api.loader.java.type.WithAlias;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

abstract class AbstractModelLoaderDelegate {
    protected final DefaultJavaModelLoaderDelegate loader;

    AbstractModelLoaderDelegate(DefaultJavaModelLoaderDelegate loader) {
        this.loader = loader;
    }

    protected ClassLoader getExtensionClassLoader() {
        return this.getExtensionType().map(Class::getClassLoader).orElseGet(ExtensionModel.class::getClassLoader);
    }

    protected Optional<Class<?>> getExtensionType() {
        return Optional.ofNullable(this.loader.getExtensionType());
    }

    protected ExtensionElement getExtensionElement() {
        return this.loader.getExtensionElement();
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.loader.getConfigLoaderDelegate();
    }

    OperationModelLoaderDelegate getOperationModelLoaderDelegate() {
        return this.loader.getOperationLoaderDelegate();
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.loader.getSourceModelLoaderDelegate();
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.loader.getConnectionProviderModelLoaderDelegate();
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.loader.getOperationLoaderDelegate();
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.loader.getFunctionModelLoaderDelegate();
    }

    ClassTypeLoader getTypeLoader() {
        return this.loader.getTypeLoader();
    }

    void processComponentConnectivity(ExecutableComponentDeclarer componentDeclarer, WithParameters component, WithAlias alias) {
        List<ExtensionParameter> connectionParameters = component.getParametersAnnotatedWith(Connection.class);
        if (connectionParameters.isEmpty()) {
            ((ExecutableComponentDeclarer)componentDeclarer.requiresConnection(false)).transactional(false);
        } else if (connectionParameters.size() == 1) {
            ExtensionParameter connectionParameter = connectionParameters.iterator().next();
            Type connectionType = this.resolveConnectionType(componentDeclarer, connectionParameter, alias);
            ((ComponentDeclarer)((ExecutableComponentDeclarer)componentDeclarer.requiresConnection(true)).transactional(connectionType.isAssignableTo(TransactionalConnection.class))).withModelProperty(new ConnectivityModelProperty(connectionType));
        } else {
            throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines %d parameters annotated with @%s. Only one is allowed", NameUtils.getComponentDeclarationTypeName(componentDeclarer.getDeclaration()), alias.getAlias(), connectionParameters.size(), Connection.class.getSimpleName()));
        }
    }

    private Type resolveConnectionType(ExecutableComponentDeclarer componentDeclarer, ExtensionParameter connectionParameter, WithAlias alias) {
        Type connectionType = connectionParameter.getType();
        if (connectionType.getTypeName().startsWith(ConnectionProvider.class.getName())) {
            List<TypeGeneric> generics = connectionType.getGenerics();
            if (generics.size() == 0) {
                throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines a %s without a connection type. Please add the generic", NameUtils.getComponentDeclarationTypeName(componentDeclarer.getDeclaration()), alias.getAlias(), ConnectionProvider.class.getSimpleName()));
            }
            return generics.get(0).getConcreteType();
        }
        return connectionType;
    }

    void processMimeType(HasModelProperties declarer, WithAnnotations element) {
        element.getAnnotation(MediaType.class).ifPresent(a -> declarer.withModelProperty(new MediaTypeModelProperty(a.value(), a.strict())));
    }

    void declareParameters(ComponentDeclarer component, List<ExtensionParameter> methodParameters, List<ExtensionParameter> fieldParameters, ParameterDeclarationContext declarationContext) {
        this.loader.getMethodParametersLoader().declare(component, methodParameters, declarationContext);
        this.loader.getFieldParametersLoader().declare(component, fieldParameters, declarationContext).forEach(p -> {
            p.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            p.withModelProperty(new FieldOperationParameterModelProperty());
        });
    }
}

