/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Route;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class RouterModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CONSTRUCT = "Construct";
    private static final List<Class<?>> VALID_CALLBACK_PARAMETERS = Arrays.asList(RouterCompletionCallback.class, VoidCompletionCallback.class);
    private final Map<MethodElement, ConstructDeclarer> constructDeclarers = new HashMap<MethodElement, ConstructDeclarer>();

    RouterModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareRouter(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, OperationContainerElement enclosingType, OperationElement routerMethod, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        OperationModelLoaderDelegate.checkDefinition(!configParameter.isPresent(), String.format("Scope '%s' requires a config, but that is not allowed, remove such parameter", routerMethod.getName()));
        OperationModelLoaderDelegate.checkDefinition(!connectionParameter.isPresent(), String.format("Scope '%s' requires a connection, but that is not allowed, remove such parameter", routerMethod.getName()));
        HasConstructDeclarer actualDeclarer = (HasConstructDeclarer)((Object)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)((Object)ownerDeclarer), configParameter, connectionParameter));
        if (this.constructDeclarers.containsKey(routerMethod)) {
            actualDeclarer.withConstruct(this.constructDeclarers.get(routerMethod));
            return;
        }
        ConstructDeclarer router = actualDeclarer.withConstruct(routerMethod.getAlias());
        router.withModelProperty(new ExtensionOperationDescriptorModelProperty(routerMethod));
        Optional<Method> method = routerMethod.getMethod();
        Optional<Class<?>> declaringClass = enclosingType.getDeclaringClass();
        if (method.isPresent() && declaringClass.isPresent()) {
            ((ConstructDeclarer)router.withModelProperty(new ImplementingMethodModelProperty(method.get()))).withModelProperty(new CompletableComponentExecutorModelProperty(new CompletableOperationExecutorFactory(declaringClass.get(), method.get())));
        }
        this.processMimeType(router, routerMethod);
        List callbackParameters = routerMethod.getParameters().stream().filter(p -> VALID_CALLBACK_PARAMETERS.stream().anyMatch(validType -> p.getType().isSameType((Class<?>)validType))).collect(Collectors.toList());
        List<ExtensionParameter> routes = routerMethod.getParameters().stream().filter(this::isRoute).collect(Collectors.toList());
        OperationModelLoaderDelegate.checkDefinition(!callbackParameters.isEmpty(), String.format("Router '%s' does not declare a parameter with one of the types '%s'. One is required.", routerMethod.getAlias(), VALID_CALLBACK_PARAMETERS));
        OperationModelLoaderDelegate.checkDefinition(!routes.isEmpty(), String.format("Router '%s' does not declare a '%s' parameter. One is required.", routerMethod.getAlias(), Route.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(callbackParameters.size() <= 1, String.format("Router '%s' defines more than one CompletionCallback parameters. Only one is allowed", routerMethod.getAlias()));
        OperationModelLoaderDelegate.checkDefinition(IntrospectionUtils.isVoid(routerMethod), String.format("Router '%s' is not declared in a void method.", routerMethod.getAlias()));
        List<ExtensionParameter> nonRouteParameters = routerMethod.getParameters().stream().filter(p -> !this.isRoute((ExtensionParameter)p) && !callbackParameters.contains(p)).collect(Collectors.toList());
        this.declareParameters(router, nonRouteParameters, ((OperationContainerElement)routerMethod.getEnclosingType()).getParameters(), new ParameterDeclarationContext(CONSTRUCT, (NamedDeclaration)router.getDeclaration()));
        this.declareRoutes(router, routes);
    }

    private void declareRoutes(ConstructDeclarer router, List<ExtensionParameter> routes) {
        routes.forEach(route -> {
            NestedRouteDeclarer routeDeclarer = router.withRoute(route.getAlias()).describedAs(route.getDescription()).withMinOccurs(route.isRequired() ? 1 : 0);
            route.getType().getDeclaringClass().ifPresent(clazz -> routeDeclarer.withModelProperty(new ImplementingTypeModelProperty((Class<?>)clazz)));
            List<FieldElement> parameters = route.getType().getAnnotatedFields(Parameter.class);
            this.loader.getFieldParametersLoader().declare(routeDeclarer, parameters, new ParameterDeclarationContext(CONSTRUCT, (NamedDeclaration)router.getDeclaration()));
        });
    }

    private boolean isRoute(ExtensionParameter parameter) {
        return parameter.getType().isAssignableTo(Route.class);
    }
}

