/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.VariableElement;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.springframework.core.ResolvableType;

public class FieldWrapper
implements FieldElement {
    private final Field field;
    private final FieldSetter fieldSetter;
    private final ClassTypeLoader typeLoader;

    public FieldWrapper(Field field, ClassTypeLoader typeLoader) {
        this.field = field;
        this.fieldSetter = new FieldSetter(field);
        this.typeLoader = typeLoader;
    }

    @Override
    public Optional<Field> getField() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public void set(Object object, Object value) {
        this.fieldSetter.set(object, value);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getAnnotation(annotationClass));
    }

    @Override
    public TypeWrapper getType() {
        return new TypeWrapper(ResolvableType.forField((Field)this.field), this.typeLoader);
    }

    @Override
    public String getAlias() {
        return InfrastructureFieldContributor.getInfrastructureType(this.getType()).map(InfrastructureTypeMapping.InfrastructureType::getName).orElse(FieldElement.super.getAlias());
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Class: '%s'", this.field.getDeclaringClass().getSimpleName());
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.field, this.typeLoader)) : Optional.empty();
    }

    @Override
    public Optional<VariableElement> getElement() {
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldWrapper) {
            return Objects.equals(((FieldWrapper)obj).field, this.field);
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

