/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConfig;
import org.mule.runtime.module.extension.internal.store.LazyObjectStoreToMapAdapter;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class PlatformManagedOAuthHandler
extends OAuthHandler<PlatformManagedOAuthDancer> {
    public PlatformManagedOAuthDancer register(PlatformManagedOAuthConfig config) {
        return this.register(config, Collections.emptyList());
    }

    public PlatformManagedOAuthDancer register(PlatformManagedOAuthConfig config, List<PlatformManagedOAuthStateListener> listeners) {
        return this.dancers.computeIfAbsent(config.getOwnerConfigName(), k -> this.createDancer(config, listeners));
    }

    public void refreshToken(PlatformManagedOAuthConfig config) {
        PlatformManagedOAuthDancer dancer = (PlatformManagedOAuthDancer)this.dancers.get(config.getOwnerConfigName());
        try {
            dancer.refreshToken().get();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not refresh token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
        }
    }

    public ResourceOwnerOAuthContext getOAuthContext(PlatformManagedOAuthConfig config) {
        PlatformManagedOAuthDancer dancer = (PlatformManagedOAuthDancer)this.dancers.get(config.getOwnerConfigName());
        if (dancer == null) {
            throw new IllegalStateException(String.format("PlatformManaged dancer for config '%s' not yet registered", config.getOwnerConfigName()));
        }
        ResourceOwnerOAuthContext contextForResourceOwner = dancer.getContext();
        if (contextForResourceOwner == null || contextForResourceOwner.getAccessToken() == null) {
            try {
                dancer.accessToken().get();
                contextForResourceOwner = dancer.getContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not obtain access token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
            }
        }
        return contextForResourceOwner;
    }

    public void invalidate(PlatformManagedOAuthConfig config) {
        PlatformManagedOAuthDancer dancer = (PlatformManagedOAuthDancer)this.dancers.get(config.getOwnerConfigName());
        if (dancer == null) {
            return;
        }
        dancer.invalidateContext();
    }

    private PlatformManagedOAuthDancer createDancer(PlatformManagedOAuthConfig config, List<PlatformManagedOAuthStateListener> listeners) throws MuleException {
        Preconditions.checkArgument(listeners != null, "listeners cannot be null");
        OAuthPlatformManagedDancerBuilder dancerBuilder = ((OAuthService)this.oauthService.get()).platformManagedOAuthDancerBuilder(this.lockFactory, new LazyObjectStoreToMapAdapter(() -> (ObjectStore)this.objectStoreLocator.apply(config)), this.expressionEvaluator);
        PlatformManagedOAuthGrantType grantType = config.getGrantType();
        dancerBuilder.connectionUri(config.getConnectionUri()).platformUrl(config.getServiceUrl()).organizationId(config.getOrgId()).apiVersion(config.getApiVersion()).name(config.getOwnerConfigName()).tokenUrl(config.getPlatformAuthUrl()).encoding(config.getEncoding()).clientCredentials(config.getClientId(), config.getClientSecret()).tokenUrl(config.getPlatformAuthUrl()).responseExpiresInExpr(config.getDelegateGrantType().getExpirationRegex()).responseAccessTokenExpr(grantType.getAccessTokenExpr()).withClientCredentialsIn(ClientCredentialsLocation.BODY).resourceOwnerIdTransformer(ownerId -> ownerId + "-" + config.getOwnerConfigName());
        dancerBuilder.customParametersExtractorsExprs(this.getParameterExtractors(ExtensionsOAuthUtils.getCallbackValuesExtractors(config.getDelegateConnectionProviderModel())));
        listeners.forEach(dancerBuilder::addListener);
        PlatformManagedOAuthDancer dancer = (PlatformManagedOAuthDancer)dancerBuilder.build();
        if (this.started) {
            this.start(dancer);
        }
        return dancer;
    }

    @Override
    protected Function<OAuthConfig, ObjectStore> buildObjectStoreLocator() {
        return config -> this.objectStoreManager.getOrCreateObjectStore(config.getOwnerConfigName() + "-OCS-tokenStore", ObjectStoreSettings.unmanagedTransient());
    }
}

