/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.deprecated;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.deprecated.MonoCompletionCallback;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class ReactiveOperationExecutionWrapper<M extends ComponentModel>
implements ComponentExecutor<M>,
OperationArgumentResolverFactory<M>,
Lifecycle,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveOperationExecutionWrapper.class);
    private final ComponentExecutor<M> delegate;
    private MuleContext muleContext;

    public ReactiveOperationExecutionWrapper(ComponentExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    public Publisher<Object> execute(ExecutionContext<M> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        return Mono.create(sink -> {
            MonoCompletionCallback callback = new MonoCompletionCallback((MonoSink<Object>)sink);
            context.setVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM", callback);
            try {
                this.delegate.execute(executionContext);
            }
            catch (Throwable t) {
                sink.error(Exceptions.wrapFatal(t));
            }
        });
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)((Object)this.delegate)).createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

