/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullSafeValueResolverWrapper<T>
implements ValueResolver<T>,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NullSafeValueResolverWrapper.class);
    private final ValueResolver<T> delegate;
    private final ValueResolver<T> fallback;
    private final MuleContext muleContext;

    public static <T> ValueResolver<T> of(final ValueResolver<T> delegate, MetadataType type, final ReflectionCache reflectionCache, final ExpressionManager expressionManager, final MuleContext muleContext, final ObjectTypeParametersResolver parametersResolver) {
        Preconditions.checkArgument(delegate != null, "delegate cannot be null");
        final Reference wrappedResolver = new Reference();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                Class clazz = JavaTypeUtils.getType(objectType);
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    MapValueResolver fallback = MapValueResolver.of(clazz, Collections.emptyList(), Collections.emptyList(), reflectionCache, muleContext);
                    wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, fallback, muleContext));
                    return;
                }
                String requiredFields = objectType.getFields().stream().filter(f -> f.isRequired() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup(f)).map(MetadataTypeUtils::getLocalPart).collect(Collectors.joining(", "));
                if (!StringUtils.isBlank((CharSequence)requiredFields)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Class '%s' cannot be used with NullSafe Wrapper since it contains non optional fields: [%s]", clazz.getName(), requiredFields));
                    }
                    wrappedResolver.set(delegate);
                    return;
                }
                ResolverSet resolverSet = new ResolverSet(muleContext);
                for (Field field : IntrospectionUtils.getFields(clazz)) {
                    ValueResolver<Object> fieldResolver = null;
                    ObjectFieldType objectField = objectType.getFieldByName(IntrospectionUtils.getAlias(field)).orElse(null);
                    if (objectField == null) continue;
                    Optional<String> defaultValue = MetadataTypeUtils.getDefaultValue(objectField);
                    if (defaultValue.isPresent()) {
                        fieldResolver = ResolverUtils.getFieldDefaultValueValueResolver(objectField, muleContext);
                    } else if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup(objectField)) {
                        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(JavaTypeUtils.getType(objectField.getValue()), reflectionCache);
                        resolverSet.add(field.getName(), new ObjectBuilderValueResolver(groupBuilder, muleContext));
                        ObjectType childGroup = (ObjectType)objectField.getValue();
                        parametersResolver.resolveParameters(childGroup, groupBuilder);
                        parametersResolver.resolveParameterGroups(childGroup, groupBuilder);
                    } else {
                        NullSafe nullSafe = field.getAnnotation(NullSafe.class);
                        if (nullSafe != null) {
                            Class<?> nullSafeClass = nullSafe.defaultImplementingType();
                            MetadataType nullSafeType = Object.class.equals(nullSafeClass) ? objectField.getValue() : new BaseTypeBuilder(MetadataFormat.JAVA).objectType().id(nullSafeClass.getName()).with(new ClassInformationAnnotation(nullSafeClass)).build();
                            fieldResolver = NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), nullSafeType, reflectionCache, expressionManager, muleContext, parametersResolver);
                        }
                        if (field.getAnnotation(ConfigOverride.class) != null) {
                            StaticValueResolver<Object> fieldDelegate = fieldResolver != null ? fieldResolver : new StaticValueResolver<Object>(null);
                            fieldResolver = ConfigOverrideValueResolverWrapper.of(fieldDelegate, field.getName(), field.getType(), reflectionCache, muleContext, clazz.getName());
                        }
                    }
                    if (fieldResolver == null) continue;
                    resolverSet.add(field.getName(), fieldResolver);
                }
                DefaultResolverSetBasedObjectBuilder objectBuilder = new DefaultResolverSetBasedObjectBuilder(clazz, resolverSet, expressionManager, muleContext);
                wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, new ObjectBuilderValueResolver(objectBuilder, muleContext), muleContext));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                Class collectionClass = JavaTypeUtils.getType(arrayType);
                CollectionValueResolver fallback = CollectionValueResolver.of(collectionClass, Collections.emptyList());
                wrappedResolver.set(new NullSafeValueResolverWrapper(delegate, fallback, muleContext));
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Class '%s' cannot be used with NullSafe Wrapper since it is of a simple type", JavaTypeUtils.getType(metadataType).getName()));
                }
                wrappedResolver.set(delegate);
            }
        });
        return (ValueResolver)wrappedResolver.get();
    }

    private NullSafeValueResolverWrapper(ValueResolver<T> delegate, ValueResolver<T> fallback, MuleContext muleContext) {
        this.delegate = delegate;
        this.fallback = fallback;
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        T value = this.delegate.resolve(context);
        return value == null ? this.fallback.resolve(context) : value;
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic() || this.fallback.isDynamic();
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.fallback, this.muleContext);
    }
}

