/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.CredentialsBuilder;
import org.mule.runtime.api.security.DefaultMuleAuthentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.runtime.security.DefaultCredentialsBuilder;

public class DefaultAuthenticationHandler
implements AuthenticationHandler {
    private SecurityContext securityContext;
    private SecurityManager manager;
    private final Consumer<SecurityContext> securityContextUpdater;

    public DefaultAuthenticationHandler(SecurityContext securityContext, SecurityManager manager, Consumer<SecurityContext> securityContextUpdater) {
        this.securityContext = securityContext;
        this.manager = manager;
        this.securityContextUpdater = securityContextUpdater;
    }

    @Override
    public void setAuthentication(Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        Authentication authResult = this.manager.authenticate(authentication);
        if (this.securityContext == null) {
            this.securityContext = this.manager.createSecurityContext(authResult);
        }
        this.securityContext.setAuthentication(authResult);
        this.securityContextUpdater.accept(this.securityContext);
    }

    @Override
    public void setAuthentication(List<String> securityProviders, Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        if (!securityProviders.isEmpty()) {
            ArrayList<SecurityProvider> providers = new ArrayList<SecurityProvider>();
            for (String sp2 : securityProviders) {
                SecurityProvider provider = this.manager.getProvider(sp2);
                if (provider != null) {
                    providers.add(provider);
                    continue;
                }
                throw new SecurityProviderNotFoundException(sp2);
            }
            this.manager = new DefaultMuleSecurityManager(providers);
        }
        this.setAuthentication(authentication);
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return this.securityContext != null ? Optional.ofNullable(this.securityContext.getAuthentication()) : Optional.empty();
    }

    @Override
    public Authentication createAuthentication(Credentials credentials) {
        return new DefaultMuleAuthentication(credentials);
    }

    @Override
    public CredentialsBuilder createCredentialsBuilder() {
        return new DefaultCredentialsBuilder();
    }
}

