/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.launcher.api.log4j2.AsyncLoggerExceptionHandler;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.SimpleContextSelector;

public class MuleLog4jContextFactory
extends Log4jContextFactory
implements Disposable,
ShutdownCallbackRegistry {
    public static final boolean LOG_SEPARATION_ENABLED = System.getProperty("mule.disableLogSeparation") == null;
    private static final String LOG_CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    private static final String DEFAULT_LOG_CONFIGURATION_FACTORY = XmlConfigurationFactory.class.getName();
    private static final String ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY = "AsyncLoggerConfig.ExceptionHandler";
    private static final String DEFAULT_ASYNC_LOGGER_EXCEPTION_HANDLER = AsyncLoggerExceptionHandler.class.getName();

    public MuleLog4jContextFactory() {
        this(LOG_SEPARATION_ENABLED);
    }

    public MuleLog4jContextFactory(boolean logSeparationEnabled) {
        this((ContextSelector)(logSeparationEnabled ? new ArtifactAwareContextSelector() : new SimpleContextSelector()));
    }

    public MuleLog4jContextFactory(ContextSelector contextSelector) {
        super(contextSelector, (ShutdownCallbackRegistry)new MuleShutdownCallbackRegistry());
        this.initialise();
    }

    protected void initialise() {
        this.setupConfigurationFactory();
        this.setupAsyncLoggerExceptionHandler();
    }

    private void setupConfigurationFactory() {
        System.setProperty(LOG_CONFIGURATION_FACTORY_PROPERTY, DEFAULT_LOG_CONFIGURATION_FACTORY);
    }

    private void setupAsyncLoggerExceptionHandler() {
        String handler = System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY);
        if (StringUtils.isBlank((CharSequence)handler)) {
            System.setProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, DEFAULT_ASYNC_LOGGER_EXCEPTION_HANDLER);
        }
    }

    @Override
    public void dispose() {
        ContextSelector selector = this.getSelector();
        if (selector instanceof Disposable) {
            ((Disposable)selector).dispose();
        }
        MuleShutdownCallbackRegistry shutdownCallbackRegistry = (MuleShutdownCallbackRegistry)this.getShutdownCallbackRegistry();
        shutdownCallbackRegistry.dispose();
    }

    private static class MuleShutdownCallbackRegistry
    implements ShutdownCallbackRegistry,
    Disposable {
        private final ExecutorService executorService = Executors.newCachedThreadPool(runnable -> new Thread(runnable, "[MuleRuntime].log4j.shudownhook"));
        private final List<Runnable> hooks = new ArrayList<Runnable>();

        private MuleShutdownCallbackRegistry() {
        }

        public Cancellable addShutdownCallback(final Runnable callback) {
            this.hooks.add(callback);
            return new Cancellable(){

                public void cancel() {
                    hooks.remove(callback);
                }

                public void run() {
                    callback.run();
                }
            };
        }

        @Override
        public void dispose() {
            for (Runnable hook : new ArrayList<Runnable>(this.hooks)) {
                this.executorService.submit(hook);
            }
            try {
                this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executorService.shutdownNow();
        }
    }
}

