/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleServiceManager
implements ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleServiceManager.class);
    private static final String SCHEDULER_SERVICE_ARTIFACT_ID = "Scheduler service";
    private static final String HTTP_SERVICE_ARTIFACT_PREFIX = "HTTP";
    private final ServiceDiscoverer serviceDiscoverer;
    private List<Service> services = new ArrayList<Service>();

    public MuleServiceManager(ServiceDiscoverer serviceDiscoverer) {
        Preconditions.checkArgument(serviceDiscoverer != null, "serviceDiscoverer cannot be null");
        this.serviceDiscoverer = serviceDiscoverer;
    }

    @Override
    public void start() throws MuleException {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        if (!servicesFolder.exists()) {
            servicesFolder.mkdir();
        }
        try {
            this.services = this.serviceDiscoverer.discoverServices();
            this.startServices();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
    }

    private void startServices() throws MuleException {
        for (Service service : this.services) {
            LifecycleUtils.startIfNeeded(service);
        }
    }

    @Override
    public void stop() throws MuleException {
        Service schedulerService = null;
        Service httpService = null;
        for (Service service : this.services) {
            if (service.getName().equals(SCHEDULER_SERVICE_ARTIFACT_ID)) {
                schedulerService = service;
                continue;
            }
            if (service.getName().contains(HTTP_SERVICE_ARTIFACT_PREFIX)) {
                httpService = service;
                continue;
            }
            this.doStopService(service);
        }
        if (httpService != null) {
            this.doStopService(httpService);
        }
        if (schedulerService != null) {
            this.doStopService(schedulerService);
        }
    }

    protected void doStopService(Service service) {
        try {
            LifecycleUtils.stopIfNeeded(service);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to stop service '%s': %s", service.getName(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public List<Service> getServices() {
        return Collections.unmodifiableList(this.services);
    }
}

