/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.oauth.internal.builder;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.AuthorizationCodeRequest;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.http.HttpClientFactory;
import org.mule.runtime.oauth.api.listener.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.internal.DefaultAuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.internal.builder.AbstractOAuthDancerBuilder;
import org.mule.runtime.oauth.internal.config.AuthDancerCredentialConfig;
import org.mule.runtime.oauth.internal.config.DefaultAuthorizationCodeOAuthDancerConfig;
import org.mule.runtime.oauth.internal.config.TokenParserConfig;
import org.mule.runtime.oauth.internal.util.MultiMapUtils;

public class DefaultOAuthAuthorizationCodeDancerBuilder
extends AbstractOAuthDancerBuilder<AuthorizationCodeOAuthDancer>
implements OAuthAuthorizationCodeDancerBuilder {
    private final HttpService httpService;
    private Supplier<HttpServer> localCallbackServerFactory;
    private String localCallbackUrlPath;
    private String localAuthorizationUrlPath;
    private String localAuthorizationUrlResourceOwnerId;
    private String externalCallbackUrl;
    private String state;
    private String authorizationUrl;
    private boolean includeRedirectUriInRefreshTokenRequest = true;
    private final List<AuthorizationCodeListener> listeners = new LinkedList<AuthorizationCodeListener>();
    private MultiMap<String, String> additionalRefreshTokenRequestParameters = new MultiMap();
    private MultiMap<String, String> additionalRefreshTokenHeaders = new MultiMap();
    private Supplier<Map<String, String>> customParameters = () -> Collections.emptyMap();
    private Supplier<Map<String, String>> customHeaders = () -> Collections.emptyMap();
    private Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback = r -> k -> Optional.empty();
    private BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback = (vars, ctx) -> {};

    public DefaultOAuthAuthorizationCodeDancerBuilder(SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpService httpService, HttpClientFactory httpClientFactory, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientFactory, expressionEvaluator);
        this.httpService = httpService;
        this.clientCredentialsLocation = ClientCredentialsLocation.BODY;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl) {
        this.localCallbackServerFactory = () -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort()).setName(localCallbackUrl.toString());
            try {
                return this.httpService.getServerFactory().create(serverConfigBuilder.build());
            }
            catch (ServerCreationException e) {
                throw new MuleRuntimeException(e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl, TlsContextFactory tlsContextFactory) {
        this.localCallbackServerFactory = () -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort()).setName(localCallbackUrl.toString());
            serverConfigBuilder.setTlsContextFactory(tlsContextFactory);
            try {
                return this.httpService.getServerFactory().create(serverConfigBuilder.build());
            }
            catch (ServerCreationException e) {
                throw new MuleRuntimeException(e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder localCallback(HttpServer server, String localCallbackConfigPath) {
        this.localCallbackServerFactory = () -> server;
        this.localCallbackUrlPath = localCallbackConfigPath;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlPath(String path) {
        this.localAuthorizationUrlPath = path;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlResourceOwnerId(String localAuthorizationUrlResourceOwnerIdExpr) {
        this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerIdExpr;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder customParameters(Map<String, String> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        return this.customParameters(() -> customParameters);
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder customParameters(Supplier<Map<String, String>> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        this.customParameters = customParameters;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder customHeaders(Map<String, String> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        return this.customHeaders(() -> customHeaders);
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder customHeaders(Supplier<Map<String, String>> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        this.customHeaders = customHeaders;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder state(String stateExpr) {
        this.state = stateExpr;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder authorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder externalCallbackUrl(String externalCallbackUrl) {
        this.externalCallbackUrl = externalCallbackUrl;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder beforeDanceCallback(Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback) {
        Objects.requireNonNull(beforeDanceCallback, "beforeDanceCallback cannot be null");
        this.beforeDanceCallback = beforeDanceCallback;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder afterDanceCallback(BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback) {
        Objects.requireNonNull(afterDanceCallback, "afterDanceCallback cannot be null");
        this.afterDanceCallback = afterDanceCallback;
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        return (OAuthAuthorizationCodeDancerBuilder)super.encodeClientCredentialsInBody(encodeClientCredentialsInBody);
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder addListener(AuthorizationCodeListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder addAdditionalRefreshTokenRequestParameters(MultiMap<String, String> additionalParameters) {
        Objects.requireNonNull(additionalParameters, "Cannot add null additional refresh token request parameters");
        MultiMapUtils.putAll(additionalParameters, this.additionalRefreshTokenRequestParameters);
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder addAdditionalRefreshTokenRequestHeaders(MultiMap<String, String> additionalHeaders) {
        Objects.requireNonNull(additionalHeaders, "Cannot add null additional refresh token headers");
        MultiMapUtils.putAll(additionalHeaders, this.additionalRefreshTokenHeaders);
        return this;
    }

    @Override
    public OAuthAuthorizationCodeDancerBuilder includeRedirectUriInRefreshTokenRequest(boolean includeRedirectUriInRefreshTokenRequest) {
        this.includeRedirectUriInRefreshTokenRequest = includeRedirectUriInRefreshTokenRequest;
        return this;
    }

    @Override
    public AuthorizationCodeOAuthDancer build() {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.clientId), "clientId cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.clientSecret), "clientSecret cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.tokenUrl), "tokenUrl cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.authorizationUrl), "authorizationUrl cannot be blank");
        Optional<HttpServer> httpServer = this.localCallbackServerFactory != null ? Optional.of(this.localCallbackServerFactory.get()) : Optional.empty();
        DefaultAuthorizationCodeOAuthDancerConfig config = new DefaultAuthorizationCodeOAuthDancerConfig();
        config.setName(this.name);
        config.setHttpServer(httpServer);
        config.setLocalCallbackUrlPath(this.localCallbackUrlPath);
        config.setLocalAuthorizationUrlPath(this.localAuthorizationUrlPath);
        config.setCredentialConfig(AuthDancerCredentialConfig.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withClientCredentialsLocation(this.clientCredentialsLocation).build());
        config.setTokenUrl(this.tokenUrl);
        config.setScopes(this.scopes);
        config.setExternalCallbackUrl(this.externalCallbackUrl);
        config.setEncoding(this.encoding);
        config.setLocalAuthorizationUrlResourceOwnerId(this.localAuthorizationUrlResourceOwnerId);
        config.setState(this.state);
        config.setAuthorizationUrl(this.authorizationUrl);
        config.setTokenParserConfig(TokenParserConfig.builder().withResponseAccessTokenExpr(this.responseAccessTokenExpr).withResponseRefreshTokenExpr(this.responseRefreshTokenExpr).withResponseExpiresInExpr(this.responseExpiresInExpr).build());
        config.setCustomParameters(this.customParameters);
        config.setCustomHeaders(this.customHeaders);
        config.setCustomParametersExtractorsExprs(this.customParametersExtractorsExprs);
        config.setResourceOwnerIdTransformer(this.resourceOwnerIdTransformer);
        config.setSchedulerService(this.schedulerService);
        config.setLockProvider(this.lockProvider);
        config.setTokensStore(this.tokensStore);
        config.setHttpClient((HttpClient)this.httpClientFactory.get());
        config.setExpressionEvaluator(this.expressionEvaluator);
        config.setBeforeDanceCallback(this.beforeDanceCallback);
        config.setAfterDanceCallback(this.afterDanceCallback);
        config.setListeners(this.listeners);
        config.setAdditionalRefreshTokenRequestParameters(this.additionalRefreshTokenRequestParameters);
        config.setAdditionalRefreshTokenHeaders(this.additionalRefreshTokenHeaders);
        config.setIncludeRedirectUriInRefreshTokenRequest(this.includeRedirectUriInRefreshTokenRequest);
        return new DefaultAuthorizationCodeOAuthDancer(config);
    }
}

