/*
 * Decompiled with CFR 0.152.
 */
package org.mule.sdk.api.streaming.bytes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.util.Preconditions;

public final class ImmutableFileRepeatableInputStream
extends InputStream {
    private final InputStream delegate;
    private final File file;
    private final boolean autoDelete;

    public ImmutableFileRepeatableInputStream(File file, boolean autoDelete) {
        Preconditions.checkArgument(file != null, "File cannot be null");
        try {
            this.delegate = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " does not exists", e);
        }
        this.file = file;
        this.autoDelete = autoDelete;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        if (this.autoDelete) {
            this.file.delete();
        }
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

