/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import org.mule.runtime.api.util.Preconditions;

public class PreservingClassLoaderAsyncHandler<T>
implements AsyncHandler<T> {
    private AsyncHandler<T> delegate;
    private final ClassLoader contextClassLoader;

    public PreservingClassLoaderAsyncHandler(AsyncHandler<T> delegate) {
        Preconditions.checkState(delegate != null, "Delegate cannot be null.");
        this.delegate = delegate;
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void onThrowable(Throwable throwable) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            this.delegate.onThrowable(throwable);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            AsyncHandler.STATE sTATE = this.delegate.onBodyPartReceived(httpResponseBodyPart);
            return sTATE;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            AsyncHandler.STATE sTATE = this.delegate.onStatusReceived(httpResponseStatus);
            return sTATE;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders httpResponseHeaders) throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            AsyncHandler.STATE sTATE = this.delegate.onHeadersReceived(httpResponseHeaders);
            return sTATE;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public T onCompleted() throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            Object object = this.delegate.onCompleted();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

