/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.net.InetAddress;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.ServerAddress;

public class DefaultServerAddress
implements ServerAddress {
    private final InetAddress address;
    private int port;

    public DefaultServerAddress(InetAddress address, int port) {
        this.port = port;
        this.address = address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getIp() {
        return this.address.getHostAddress();
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean overlaps(ServerAddress serverAddress) {
        return this.port == serverAddress.getPort() && (DefaultServerAddress.isAllInterfaces(this) || DefaultServerAddress.isAllInterfaces(serverAddress));
    }

    public static boolean isAllInterfaces(ServerAddress serverAddress) {
        return HttpConstants.ALL_INTERFACES_ADDRESS.equals(serverAddress.getAddress());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this.port != that.getPort()) {
            return false;
        }
        return this.address.equals(that.getAddress());
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "ServerAddress{ip='" + this.address.getHostAddress() + '\'' + ", port=" + this.port + '}';
    }
}

