/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.service.http.impl.util.TimedPipedOutputStream;

public class TimedPipedInputStream
extends InputStream {
    private byte[] ringBuffer;
    private final int ringBufferSize;
    private final long timeoutNanos;
    private CircularInteger head;
    private int length = 0;
    private boolean closedByWriter = false;
    private boolean closedByReader = false;

    public TimedPipedInputStream(int bufferSize, long timeout, TimeUnit timeUnit, TimedPipedOutputStream origin) {
        this.ringBuffer = new byte[bufferSize];
        this.ringBufferSize = bufferSize;
        this.timeoutNanos = timeUnit.toNanos(timeout);
        this.head = new CircularInteger(this.ringBufferSize, 0);
        origin.connect(this);
    }

    @Override
    public synchronized int read() throws IOException {
        try {
            int bytesAvailable = this.awaitDataAvailable();
            if (bytesAvailable > 0) {
                byte returnValue = this.ringBuffer[this.head.get()];
                this.head.increase();
                --this.length;
                this.notifyAll();
                return returnValue & 0xFF;
            }
            if (this.closedByWriter) {
                this.notifyAll();
                return -1;
            }
            throw new IOException(new TimeoutException("Timeout while reading from piped stream using a blocking read() method"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        try {
            int bytesToCopy = Integer.min(this.awaitDataAvailable(), len);
            if (bytesToCopy == 0 && this.closedByWriter) {
                this.notifyAll();
                return -1;
            }
            int firstCopy = Integer.min(this.ringBufferSize - this.head.get(), bytesToCopy);
            System.arraycopy(this.ringBuffer, this.head.get(), b, off, firstCopy);
            if (firstCopy < bytesToCopy) {
                System.arraycopy(this.ringBuffer, 0, b, off + firstCopy, bytesToCopy - firstCopy);
            }
            this.head.increase(bytesToCopy);
            this.length -= bytesToCopy;
            this.notifyAll();
            return bytesToCopy;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public synchronized int available() {
        return this.length;
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    private synchronized int awaitDataAvailable() throws InterruptedException, IOException {
        long initialNanos = System.nanoTime();
        long finalNanos = initialNanos + this.timeoutNanos;
        while (this.length <= 0 && System.nanoTime() < finalNanos && !this.closedByReader) {
            if (this.closedByWriter) {
                return 0;
            }
            this.wait(100L);
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        return this.length;
    }

    synchronized void receive(int b) throws IOException {
        this.awaitSpace();
        this.ringBuffer[(this.head.get() + this.length) % this.ringBufferSize] = (byte)(b & 0xFF);
        ++this.length;
        this.notifyAll();
    }

    void receive(byte[] bytes) throws IOException {
        this.receive(bytes, 0, bytes.length);
    }

    synchronized void receive(byte[] bytes, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        int bytesToCopy = Integer.min(this.awaitSpace(), len);
        CircularInteger destinationIndex = this.head.plus(this.length);
        int firstCopyLength = Integer.min(this.ringBufferSize - destinationIndex.get(), bytesToCopy);
        System.arraycopy(bytes, off, this.ringBuffer, destinationIndex.get(), firstCopyLength);
        if (firstCopyLength < bytesToCopy) {
            System.arraycopy(bytes, off + firstCopyLength, this.ringBuffer, 0, bytesToCopy - firstCopyLength);
        }
        this.length += bytesToCopy;
        this.notifyAll();
        this.receive(bytes, off + bytesToCopy, len - bytesToCopy);
    }

    private synchronized int awaitSpace() throws IOException {
        try {
            while (this.length == this.ringBufferSize && !this.closedByWriter && !this.closedByReader) {
                this.wait(100L);
            }
            if (this.closedByWriter || this.closedByReader) {
                throw new IOException("Pipe closed");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return this.ringBufferSize - this.length;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closedByReader = true;
        this.notifyAll();
    }

    public synchronized boolean isClosed() {
        return this.closedByReader || this.closedByWriter;
    }

    private class CircularInteger {
        private int cap;
        private int value;

        CircularInteger(int cap, int value) {
            this.cap = cap;
            this.value = value % cap;
        }

        int get() {
            return this.value;
        }

        void increase() {
            ++this.value;
            this.value %= this.cap;
        }

        void increase(int increment) {
            this.value += increment;
            this.value %= this.cap;
        }

        CircularInteger plus(int increment) {
            return new CircularInteger(this.cap, this.value + increment);
        }
    }
}

