/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.cxf.endpoint.Client;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientFactory;
import org.mule.runtime.soap.api.transport.TransportResourceLocator;
import org.mule.service.soap.client.CxfClientProvider;
import org.mule.service.soap.client.SoapCxfClient;
import org.mule.service.soap.conduit.SoapServiceConduitInitiator;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.WsdlStyle;

public class SoapCxfClientFactory
implements SoapClientFactory {
    private CxfClientProvider cxfClientProvider = new CxfClientProvider();

    @Override
    public SoapClient create(SoapClientConfiguration config) throws ConnectionException {
        WsdlModel wsdlDefinition = this.getWsdlDefinition(config);
        Client client = this.cxfClientProvider.getClient(config);
        ServiceModel service = wsdlDefinition.getService(config.getService());
        if (service == null) {
            throw new ConnectionException("Service [" + config.getService() + "] is not defined in the wsdl");
        }
        PortModel port = service.getPort(config.getPort());
        if (port == null) {
            throw new ConnectionException("Port [" + config.getPort() + "] not found in service [" + service.getName() + "]");
        }
        return new SoapCxfClient(client, wsdlDefinition, port, this.getAddress(config, port.getAddress()), config.getDispatcher(), config.getVersion(), config.getEncoding(), config.isMtomEnabled());
    }

    private String getAddress(SoapClientConfiguration config, URL serviceAddress) throws ConnectionException {
        String protocolSeparator;
        if (config.getAddress() == null && serviceAddress == null) {
            throw new ConnectionException("No address was specified and no one was found for the given configuration");
        }
        String address = config.getAddress() != null ? config.getAddress() : serviceAddress.toString();
        if (address.contains(protocolSeparator = "://")) {
            String protocol = address.substring(0, address.indexOf(protocolSeparator));
            if (Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).noneMatch(p -> p.startsWith(protocol))) {
                throw new IllegalArgumentException(String.format("cannot create a dispatcher for address [%s], known protocols are [%s]", address, Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).collect(Collectors.joining(", "))));
            }
        }
        return address;
    }

    private WsdlModel getWsdlDefinition(SoapClientConfiguration config) throws ConnectionException {
        String location = config.getWsdlLocation();
        WsdlModel wsdlModel = WsdlParser.Companion.parse(location, (ResourceLocator)new ResourceLocatorAdapter(config.getLocator()), config.getEncoding());
        if (WsdlStyle.RPC.equals((Object)wsdlModel.getStyle())) {
            throw new ConnectionException(String.format("The provided WSDL [%s] is RPC style, RPC WSDLs are not supported", location));
        }
        return wsdlModel;
    }

    private class ResourceLocatorAdapter
    implements ResourceLocator {
        private final TransportResourceLocator locator;

        public ResourceLocatorAdapter(TransportResourceLocator locator) {
            this.locator = locator;
        }

        public boolean handles(String s) {
            return this.locator.handles(s);
        }

        @NotNull
        public InputStream getResource(String s) {
            return this.locator.getResource(s);
        }
    }
}

