/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.message.Exchange;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.soap.api.exception.BadResponseException;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.message.EmptySoapResponse;
import org.mule.service.soap.message.ImmutableSoapResponse;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.w3c.dom.Document;

public final class SoapResponseGenerator {
    private final AttachmentResponseEnricher responseEnricher;

    public SoapResponseGenerator(AttachmentResponseEnricher responseEnricher) {
        this.responseEnricher = responseEnricher;
    }

    public SoapResponse generate(String operation, Object[] response, Exchange exchange) {
        Map<String, String> transportHeaders = this.getTransportHeaders(exchange);
        if (response == null) {
            return new EmptySoapResponse(transportHeaders);
        }
        Document document = this.unwrapResponse(response);
        String result = this.responseEnricher.enrich(document, operation, exchange);
        Map attachments = (Map)exchange.get((Object)"mule.soap.attachments");
        Map headers = (Map)exchange.get((Object)"mule.soap.headers");
        ByteArrayInputStream resultStream = new ByteArrayInputStream(result.getBytes());
        MediaType mediaType = this.getContentType(transportHeaders);
        return new ImmutableSoapResponse(resultStream, headers, transportHeaders, attachments, mediaType);
    }

    private MediaType getContentType(Map<String, String> transportHeaders) {
        Optional<Charset> charset;
        String ct = transportHeaders.get("content-type");
        if (ct != null && (charset = MediaType.parse(ct).getCharset()).isPresent()) {
            return MediaType.create("application", "xml", charset.get());
        }
        return MediaType.APPLICATION_XML;
    }

    private Map<String, String> getTransportHeaders(Exchange exchange) {
        Map transportHeaders = (Map)exchange.get((Object)"mule.soap.transport.headers");
        if (transportHeaders == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(transportHeaders);
        return result;
    }

    private Document unwrapResponse(Object[] response) {
        if (response.length == 0) {
            throw new BadResponseException("no elements were received in the SOAP response.");
        }
        if (response.length != 1) {
            throw new BadResponseException("the obtained response contains more than one element, only one was expected");
        }
        XMLStreamReader reader = (XMLStreamReader)response[0];
        try {
            return XmlTransformationUtils.xmlStreamReaderToDocument(reader);
        }
        catch (XmlTransformationException e) {
            throw new BadResponseException("Error transforming the XML web service response to be processed", (Throwable)e);
        }
    }
}

