/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class SoapServiceMetadataTypeUtils {
    private SoapServiceMetadataTypeUtils() {
    }

    public static ObjectType getOperationType(MetadataType bodyType) {
        Collection<ObjectFieldType> bodyFields;
        if (MetadataTypeUtils.isObjectType(bodyType) && (bodyFields = ((ObjectType)bodyType).getFields()).size() == 1) {
            return (ObjectType)bodyFields.iterator().next().getValue();
        }
        throw new IllegalArgumentException("Could not find soap operation element in the provided body MetadataType");
    }

    public static List<ObjectFieldType> getAttachmentFields(MetadataType bodyType) {
        Collection<ObjectFieldType> operationParams = SoapServiceMetadataTypeUtils.getOperationType(bodyType).getFields();
        return operationParams.stream().filter(field -> field.getValue() instanceof BinaryType).collect(Collectors.toList());
    }
}

