/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.module.reader;

import java.io.InputStream;
import java.io.Serializable;
import org.mule.weave.v2.interpreted.module.reader.exception.WeaveReaderException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.DocumentParser$;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.LiteralValueAstNode;
import org.mule.weave.v2.parser.ast.header.directives.ContentType;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveOptionName;
import org.mule.weave.v2.parser.ast.header.directives.VersionMajor;
import org.mule.weave.v2.parser.ast.header.directives.VersionMinor;
import org.mule.weave.v2.parser.ast.operators.OpNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager$;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingContext$;
import org.mule.weave.v2.parser.phase.ParsingContextSettings;
import org.mule.weave.v2.parser.phase.ParsingNotificationManager;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.versioncheck.SVersion;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0003\u0007\u00017!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0011!1\u0004A!A!\u0002\u0013\u0001\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0001\u0003!\u0011!Q\u0001\f\u0005CQa\u0012\u0001\u0005\u0002!Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006o\u0002!\t\u0001\u001f\u0002\u000f\u0003N$x+Z1wKB\u000b'o]3s\u0015\tia\"\u0001\u0004sK\u0006$WM\u001d\u0006\u0003\u001fA\ta!\\8ek2,'BA\t\u0013\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005M!\u0012A\u0001<3\u0015\t)b#A\u0003xK\u00064XM\u0003\u0002\u00181\u0005!Q.\u001e7f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u0006!a.Y7f!\t!3F\u0004\u0002&SA\u0011aEH\u0007\u0002O)\u0011\u0001FG\u0001\u0007yI|w\u000e\u001e \n\u0005)r\u0012A\u0002)sK\u0012,g-\u0003\u0002-[\t11\u000b\u001e:j]\u001eT!A\u000b\u0010\u0002\u001dM|WO]2f!J|g/\u001b3feV\t\u0001\u0007\u0005\u00022i5\t!G\u0003\u0002\u000eg)\u0011qBE\u0005\u0003kI\u0012abU8ve\u000e,\u0007K]8wS\u0012,'/A\bt_V\u00148-\u001a)s_ZLG-\u001a:!\u0003Miw\u000eZ;mK2{\u0017\rZ3s\u001b\u0006t\u0017mZ3s!\tId(D\u0001;\u0015\tYD(A\u0003qQ\u0006\u001cXM\u0003\u0002>%\u00051\u0001/\u0019:tKJL!a\u0010\u001e\u0003'5{G-\u001e7f\u0019>\fG-\u001a:NC:\fw-\u001a:\u0002\u0007\r$\b\u0010\u0005\u0002C\u000b6\t1I\u0003\u0002E%\u0005)Qn\u001c3fY&\u0011ai\u0011\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003J\u001b:{EC\u0001&M!\tY\u0005!D\u0001\r\u0011\u0015\u0001e\u0001q\u0001B\u0011\u0015\u0011c\u00011\u0001$\u0011\u0015qc\u00011\u00011\u0011\u00159d\u00011\u00019\u0003-Ig\u000e];u'R\u0014X-Y7\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0005%|'\"A,\u0002\t)\fg/Y\u0005\u00033R\u00131\"\u00138qkR\u001cFO]3b[\u0006a\u0011N\u001c9viN#(/Z1nA\u00059Ao\u001c,bYV,GCA/pa\tqf\rE\u0002`E\u0012l\u0011\u0001\u0019\u0006\u0003C\u000e\u000baA^1mk\u0016\u001c\u0018BA2a\u0005\u00151\u0016\r\\;f!\t)g\r\u0004\u0001\u0005\u0013\u001dL\u0011\u0011!A\u0001\u0006\u0003A'aA0%cE\u0011\u0011\u000e\u001c\t\u0003;)L!a\u001b\u0010\u0003\u000f9{G\u000f[5oOB\u0011Q$\\\u0005\u0003]z\u00111!\u00118z\u0011\u0015\u0001\u0018\u00021\u0001r\u0003\u001d\t7\u000f\u001e(pI\u0016\u0004\"A];\u000e\u0003MT!\u0001\u001e\u001f\u0002\u0007\u0005\u001cH/\u0003\u0002wg\n9\u0011i\u001d;O_\u0012,\u0017!\u00029beN,G#A=1\u0005id\bcA0cwB\u0011Q\r \u0003\n{*\t\t\u0011!A\u0003\u0002!\u00141a\u0018\u00133\u0001")
public class AstWeaveParser {
    private final String name;
    private final SourceProvider sourceProvider;
    private final ModuleLoaderManager moduleLoaderManager;
    private final InputStream inputStream;

    public SourceProvider sourceProvider() {
        return this.sourceProvider;
    }

    private InputStream inputStream() {
        return this.inputStream;
    }

    public Value<?> toValue(AstNode astNode) {
        Object object;
        ObjectValueBuilder objectValueBuilder;
        ObjectValueBuilder builder = new ObjectValueBuilder();
        builder.addPair("class", astNode.getClass().getSimpleName());
        AstNode astNode2 = astNode;
        if (astNode2 instanceof ContentType) {
            ContentType contentType = (ContentType)astNode2;
            objectValueBuilder = builder.addPair("value", contentType.mime());
        } else if (astNode2 instanceof LiteralValueAstNode) {
            LiteralValueAstNode literalValueAstNode = (LiteralValueAstNode)astNode2;
            objectValueBuilder = builder.addPair("value", literalValueAstNode.literalValue());
        } else if (astNode2 instanceof OpNode) {
            OpNode opNode = (OpNode)astNode2;
            objectValueBuilder = builder.addPair("value", opNode.opId().getClass().getSimpleName());
        } else if (astNode2 instanceof VersionMinor) {
            VersionMinor versionMinor = (VersionMinor)astNode2;
            objectValueBuilder = builder.addPair("value", versionMinor.v());
        } else if (astNode2 instanceof VersionMajor) {
            VersionMajor versionMajor = (VersionMajor)astNode2;
            objectValueBuilder = builder.addPair("value", versionMajor.v());
        } else if (astNode2 instanceof DirectiveOptionName) {
            DirectiveOptionName directiveOptionName = (DirectiveOptionName)astNode2;
            objectValueBuilder = builder.addPair("value", directiveOptionName.name());
        } else if (astNode2 instanceof NameIdentifier) {
            NameIdentifier nameIdentifier = (NameIdentifier)astNode2;
            objectValueBuilder = builder.addPair("value", nameIdentifier.name());
        } else {
            objectValueBuilder = BoxedUnit.UNIT;
        }
        Seq<AstNode> nodes = astNode.children();
        if (nodes.nonEmpty()) {
            ArrayValue children = ArrayValue$.MODULE$.apply((Seq)nodes.map((Function1 & Serializable & scala.Serializable)node -> this.toValue((AstNode)node), Seq$.MODULE$.canBuildFrom()));
            object = builder.addPair("children", children);
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public Value<?> parse() {
        WeaveResource stream = WeaveResourceFactory$.MODULE$.fromInputStream(this.name, this.inputStream());
        NameIdentifier x$1 = new NameIdentifier(this.name, NameIdentifier$.MODULE$.apply$default$2());
        MessageCollector x$2 = new MessageCollector();
        ModuleParsingPhasesManager x$3 = ModuleParsingPhasesManager$.MODULE$.apply(this.moduleLoaderManager);
        boolean x$4 = false;
        Option<ParsingContext> x$5 = ParsingContext$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = ParsingContext$.MODULE$.$lessinit$greater$default$5();
        int x$7 = ParsingContext$.MODULE$.$lessinit$greater$default$6();
        ParsingNotificationManager x$8 = ParsingContext$.MODULE$.$lessinit$greater$default$8();
        Option<SVersion> x$9 = ParsingContext$.MODULE$.$lessinit$greater$default$9();
        ParsingContextSettings x$10 = ParsingContext$.MODULE$.$lessinit$greater$default$10();
        ParsingContext context = new ParsingContext(x$1, x$2, x$3, x$5, x$6, x$7, x$4, x$8, x$9, x$10);
        PhaseResult<ParsingResult<AstNode>> value = new DocumentParser(DocumentParser$.MODULE$.$lessinit$greater$default$1(), DocumentParser$.MODULE$.$lessinit$greater$default$2()).parse(stream, context);
        if (!value.hasResult()) {
            throw new WeaveReaderException(new StringBuilder(29).append("Problem while parsing file : ").append(value.messages().errorMessageString()).toString(), (Location)((Tuple2)value.errorMessages().head())._1());
        }
        return this.toValue(value.getResult().astNode());
    }

    public AstWeaveParser(String name, SourceProvider sourceProvider, ModuleLoaderManager moduleLoaderManager, EvaluationContext ctx) {
        this.name = name;
        this.sourceProvider = sourceProvider;
        this.moduleLoaderManager = moduleLoaderManager;
        this.inputStream = sourceProvider.asInputStream(ctx);
    }
}

