/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.indexed;

import java.io.DataInputStream;
import java.nio.charset.Charset;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryParserInput;
import org.mule.weave.v2.module.dwb.reader.indexed.WeaveBinaryValue$;
import org.mule.weave.v2.module.xml.reader.indexed.TokenArray;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class BinaryValueRetriever$ {
    public static BinaryValueRetriever$ MODULE$;
    private final Charset charset;

    static {
        new BinaryValueRetriever$();
    }

    private Charset charset() {
        return this.charset;
    }

    public String readShortString(DataInputStream input) {
        int length = input.readUnsignedShort();
        return this.readString(input, length);
    }

    public String readShortString(DataInputStream input, byte[] buffer) {
        int length = input.readUnsignedShort();
        return this.readString(input, length, buffer);
    }

    public String readString(DataInputStream input, int length) {
        byte[] buffer = new byte[length];
        return this.readString(input, length, buffer);
    }

    public String readString(DataInputStream input, int length, byte[] buffer) {
        input.readFully(buffer, 0, length);
        return new String(buffer, 0, length, this.charset());
    }

    public KeyValue readKey(long keyTokenIndex, long[] keyToken, BinaryParserInput input) {
        KeyValue keyValue;
        int tokenType;
        String name = WeaveBinaryValue$.MODULE$.readLocalName(input, keyToken);
        int n = tokenType = DwTokenHelper$.MODULE$.getTokenType(keyToken);
        if (DwTokenType$.MODULE$.Key() == n) {
            QualifiedName qName = new QualifiedName(name, (Option<Namespace>)None$.MODULE$);
            keyValue = KeyValue$.MODULE$.apply(qName, (Option<Value<NameSeq>>)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            Namespace namespace = this.readNamespace(keyToken, input);
            QualifiedName qName = new QualifiedName(name, (Option<Namespace>)new Some((Object)namespace));
            keyValue = KeyValue$.MODULE$.apply(qName, (Option<Value<NameSeq>>)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            QualifiedName qName = new QualifiedName(name, (Option<Namespace>)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes(keyTokenIndex, input);
            keyValue = KeyValue$.MODULE$.apply(qName, (Option<Value<NameSeq>>)new Some(attrs));
        } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            Namespace namespace = this.readNamespace(keyToken, input);
            QualifiedName qName = new QualifiedName(name, (Option<Namespace>)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes(keyTokenIndex, input);
            keyValue = KeyValue$.MODULE$.apply(qName, (Option<Value<NameSeq>>)new Some(attrs));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Got '").append(DwTokenType$.MODULE$.getNameFor(tokenType)).append("' token while reading keys").toString());
        }
        return keyValue;
    }

    public Namespace readNamespace(long[] token, BinaryParserInput input) {
        Option<Object> nsIndexMaybe = DwTokenHelper$.MODULE$.getNsIndex(token);
        Namespace namespace = (Namespace)input.namespaces().apply(BoxesRunTime.unboxToInt((Object)nsIndexMaybe.get()));
        return namespace;
    }

    public Value<NameSeq> readAttributes(long keyTokenIndex, BinaryParserInput input) {
        TokenArray tokenArray = input.tokenArray();
        long[] keyToken = tokenArray.apply(keyTokenIndex);
        long offset = DwTokenHelper$.MODULE$.getOffset(keyToken);
        input.seekableStream().seek(offset);
        ArrayBuffer attrPairs = new ArrayBuffer();
        DataInputStream dis = input.dataInputStream();
        int attrCount = dis.readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            long pairPos = keyTokenIndex + (long)(i * 2);
            String nameStr = WeaveBinaryValue$.MODULE$.readLocalName(input, tokenArray.apply(pairPos + 1L));
            KeyValue key = KeyValue$.MODULE$.apply(nameStr);
            Value<?> value = WeaveBinaryValue$.MODULE$.apply(pairPos + 2L, (Option<Object>)None$.MODULE$, input);
            attrPairs.$plus$eq((Object)new NameValuePair(key, value));
        }
        return AttributesValue$.MODULE$.apply((Seq<NameValuePair>)attrPairs);
    }

    private BinaryValueRetriever$() {
        MODULE$ = this;
        this.charset = Charset.forName("UTF-8");
    }
}

