/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.weave.v2.io.MemoryService;
import org.mule.weave.v2.io.TrackingClosable;
import org.mule.weave.v2.io.service.BufferFileClassifier$;
import org.mule.weave.v2.io.service.WorkingDirectoryService;
import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.ILongArray;
import org.mule.weave.v2.module.reader.ILongArray$LongArrayIterator$;
import org.mule.weave.v2.module.reader.PersistedLongArray$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u001a5\u0001\u0005C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A1\r\u0001B\u0001B\u0003%A\rC\u0003h\u0001\u0011\u0005\u0001\u000e\u0003\u0005n\u0001!\u0015\r\u0011\"\u0001o\u0011!!\b\u0001#b\u0001\n\u0003)\bbB=\u0001\u0001\u0004%\tA\u001f\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000bAq!!\u0005\u0001A\u0003&1\u0010\u0003\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0001{\u0011%\t)\u0002\u0001a\u0001\n\u0003\t9\u0002C\u0004\u0002\u001c\u0001\u0001\u000b\u0015B>\t\u0011\u0005u\u0001\u00011A\u0005\u0002iD\u0011\"a\b\u0001\u0001\u0004%\t!!\t\t\u000f\u0005\u0015\u0002\u0001)Q\u0005w\"I\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011\u0011\u0006\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002,!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00028!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u00028!A\u0011\u0011\n\u0001A\u0002\u0013\u0005!\u0010C\u0005\u0002L\u0001\u0001\r\u0011\"\u0001\u0002N!9\u0011\u0011\u000b\u0001!B\u0013Y\b\"CA*\u0001\u0001\u0007I\u0011AA\u0015\u0011%\t)\u0006\u0001a\u0001\n\u0003\t9\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0015BA\u0016\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0005\u0002p\u0001\t\n\u0011\"\u0003\u0002r!9\u0011q\u0011\u0001\u0005\u0002\u0005}\u0003bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\t\t\u000b\u0001C\u0001\u0003?Bq!a)\u0001\t\u0013\t)\u000bC\u0004\u00024\u0002!\t%a\u0018\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"1\u0011q\u0018\u0001\u0005BiDa!!1\u0001\t\u0003R\bbBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002`\u0002!\t%a\u0018\b\u000f\u0005\u0005H\u0007#\u0001\u0002d\u001a11\u0007\u000eE\u0001\u0003KDaa\u001a\u0018\u0005\u0002\u00055\bbBAb]\u0011\u0005\u0011q\u001e\u0005\n\u0003\u007ft#\u0019!C\u0001\u0005\u0003A\u0001Ba\u0005/A\u0003%!1\u0001\u0002\u0013!\u0016\u00148/[:uK\u0012duN\\4BeJ\f\u0017P\u0003\u00026m\u00051!/Z1eKJT!a\u000e\u001d\u0002\r5|G-\u001e7f\u0015\tI$(\u0001\u0002we)\u00111\bP\u0001\u0006o\u0016\fg/\u001a\u0006\u0003{y\nA!\\;mK*\tq(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0005*s\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005-cU\"\u0001\u001b\n\u00055#$AC%M_:<\u0017I\u001d:bsB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bO\u0001\u0003S>L!a\u0015)\u0003!Q\u0013\u0018mY6j]\u001e\u001cEn\\:bE2,\u0017aF<pe.Lgn\u001a#je\u0016\u001cGo\u001c:z'\u0016\u0014h/[2f!\t1\u0016,D\u0001X\u0015\tA\u0006+A\u0004tKJ4\u0018nY3\n\u0005i;&aF,pe.Lgn\u001a#je\u0016\u001cGo\u001c:z'\u0016\u0014h/[2f\u0003=\u0019X\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0007CA/b\u001b\u0005q&B\u0001-`\u0015\t\u0001\u0007(A\u0003n_\u0012,G.\u0003\u0002c=\ny1+\u001a;uS:<7oU3sm&\u001cW-A\u0007nK6|'/_*feZL7-\u001a\t\u0003\u001f\u0016L!A\u001a)\u0003\u001b5+Wn\u001c:z'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q!\u0011N[6m!\tY\u0005\u0001C\u0003U\t\u0001\u0007Q\u000bC\u0003\\\t\u0001\u0007A\fC\u0003d\t\u0001\u0007A-\u0001\u0005uK6\u0004h)\u001b7f+\u0005y\u0007C\u00019s\u001b\u0005\t(BA)G\u0013\t\u0019\u0018O\u0001\u0003GS2,\u0017\u0001\u0005:b]\u0012|W.Q2dKN\u001ch)\u001b7f+\u00051\bC\u00019x\u0013\tA\u0018O\u0001\tSC:$w.\\!dG\u0016\u001c8OR5mK\u0006Aa-\u001b7f'&TX-F\u0001|!\tax0D\u0001~\u0015\u0005q\u0018!B:dC2\f\u0017bAA\u0001{\n!Aj\u001c8h\u000311\u0017\u000e\\3TSj,w\fJ3r)\u0011\t9!!\u0004\u0011\u0007q\fI!C\u0002\u0002\fu\u0014A!\u00168ji\"A\u0011q\u0002\u0005\u0002\u0002\u0003\u000710A\u0002yIE\n\u0011BZ5mKNK'0\u001a\u0011\u0002\u000b}\u001b\u0018N_3\u0002\u0013}\u001b\u0018N_3`I\u0015\fH\u0003BA\u0004\u00033A\u0001\"a\u0004\f\u0003\u0003\u0005\ra_\u0001\u0007?NL'0\u001a\u0011\u0002\u0019\t,hMZ3s\u001f\u001a47/\u001a;\u0002!\t,hMZ3s\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0004\u0003GA\u0001\"a\u0004\u000f\u0003\u0003\u0005\ra_\u0001\u000eEV4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\u0017\t,hMZ3s\u0019&l\u0017\u000e^\u000b\u0003\u0003W\u00012\u0001`A\u0017\u0013\r\ty# \u0002\u0004\u0013:$\u0018\u0001\u00042vM\u001a,'\u000fT5nSR\u0004\u0013A\u0003:fC\u0012\u0014UO\u001a4feV\u0011\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b$\u0002\u00079Lw.\u0003\u0003\u0002B\u0005m\"A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006Y!/Z1e\u0005V4g-\u001a:!\u0003-9(/\u001b;f\u0005V4g-\u001a:\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\u0002\u000b}c\u0017m\u001d;\u0002\u0013}c\u0017m\u001d;`I\u0015\fH\u0003BA\u0004\u0003\u001fB\u0001\"a\u0004\u0018\u0003\u0003\u0005\ra_\u0001\u0007?2\f7\u000f\u001e\u0011\u0002\u001dUtg\r\\;tQ\u0016$7i\\;oi\u0006\u0011RO\u001c4mkNDW\rZ\"pk:$x\fJ3r)\u0011\t9!!\u0017\t\u0013\u0005=!$!AA\u0002\u0005-\u0012aD;oM2,8\u000f[3e\u0007>,h\u000e\u001e\u0011\u0002\u000b\rdwn]3\u0015\u0005\u0005\u001d\u0011a\u00023p\u00072|7/\u001a\u000b\u0005\u0003\u000f\t)\u0007C\u0005\u0002hu\u0001\n\u00111\u0001\u0002j\u0005)\u0011m]=oGB\u0019A0a\u001b\n\u0007\u00055TPA\u0004C_>dW-\u00198\u0002#\u0011|7\t\\8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002t)\"\u0011\u0011NA;W\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0013Ut7\r[3dW\u0016$'bAAA{\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!C:fK.$v.R(G\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003BAG\u0003\u001fk\u0011\u0001\u0001\u0005\u0007\u0003#\u0003\u0003\u0019A>\u0002\t\u0015dW-\\\u0001\u000eIAdWo\u001d\u0013qYV\u001cH%Z9\u0015\t\u00055\u0015q\u0013\u0005\b\u00033\u000b\u0003\u0019AAN\u0003\u0015)G.Z7t!\u0011a\u0018QT>\n\u0007\u0005}UPA\u0003BeJ\f\u00170A\u0006gYV\u001c\bNQ;gM\u0016\u0014\u0018a\u0003;p\u0005f$X-\u0011:sCf$B!a*\u00020B)A0!(\u0002*B\u0019A0a+\n\u0007\u00055VP\u0001\u0003CsR,\u0007bBAYG\u0001\u0007\u00111T\u0001\u0006m\u0006dW/Z\u0001\u0006G2,\u0017M]\u0001\u0007kB$\u0017\r^3\u0015\r\u0005\u001d\u0011\u0011XA_\u0011\u0019\tY,\na\u0001w\u0006\u0019\u0011\u000e\u001a=\t\r\u0005EU\u00051\u0001|\u0003\u0011\u0019\u0018N_3\u0002\t1\f7\u000f^\u0001\u0006CB\u0004H.\u001f\u000b\u0004w\u0006\u001d\u0007BBA^Q\u0001\u000710\u0001\bjg&s7/\u001b3f\u0005V4g-\u001a:\u0015\u0011\u0005%\u0014QZAi\u0003'Da!a4*\u0001\u0004Y\u0018!D5oI\u0016D\bk\\:ji&|g\u000e\u0003\u0004\u0002\u001e%\u0002\ra\u001f\u0005\b\u0003OI\u0003\u0019AA\u0016\u00031\u0011X\r\\8bI\n+hMZ3s)\u0011\t9!!7\t\r\u0005='\u00061\u0001|\u0003-I7\u000fU3sg&\u001cH/\u001a3\u0016\u0005\u0005%\u0014\u0001\u00034j]\u0006d\u0017N_3\u0002%A+'o]5ti\u0016$Gj\u001c8h\u0003J\u0014\u0018-\u001f\t\u0003\u0017:\u001a2ALAt!\ra\u0018\u0011^\u0005\u0004\u0003Wl(AB!osJ+g\r\u0006\u0002\u0002dR\u0011\u0011\u0011\u001f\u000b\u0004S\u0006M\bbBA{a\u0001\u000f\u0011q_\u0001\u0004GRD\b\u0003BA}\u0003wl\u0011aX\u0005\u0004\u0003{|&!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\u00061AjT$H\u000bJ+\"Aa\u0001\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u00059An\\4hS:<'b\u0001B\u0007\r\u0006!Q\u000f^5m\u0013\u0011\u0011\tBa\u0002\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u0002")
public class PersistedLongArray
implements ILongArray,
TrackingClosable {
    private File tempFile;
    private RandomAccessFile randomAccessFile;
    private final WorkingDirectoryService workingDirectoryService;
    private final MemoryService memoryService;
    private long fileSize;
    private long _size;
    private long bufferOffset;
    private final int bufferLimit;
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private long _last;
    private int unflushedCount;
    private Exception org$mule$weave$v2$io$TrackingClosable$$closerResponsible;
    private volatile boolean org$mule$weave$v2$io$TrackingClosable$$closed;
    private volatile ILongArray$LongArrayIterator$ LongArrayIterator$module;
    private volatile byte bitmap$0;

    public static Logger LOGGER() {
        return PersistedLongArray$.MODULE$.LOGGER();
    }

    @Override
    public void assertNotClosed() {
        TrackingClosable.assertNotClosed$(this);
    }

    @Override
    public boolean isClosed() {
        return TrackingClosable.isClosed$(this);
    }

    @Override
    public long indexWhere(Function1<Object, Object> p, long from) {
        return ILongArray.indexWhere$(this, p, from);
    }

    @Override
    public long indexWhere$default$2() {
        return ILongArray.indexWhere$default$2$(this);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        ILongArray.foreach$(this, f);
    }

    @Override
    public Option<Object> find(Function1<Object, Object> predicate, long from) {
        return ILongArray.find$(this, predicate, from);
    }

    @Override
    public long find$default$2() {
        return ILongArray.find$default$2$(this);
    }

    @Override
    public <T> Seq<T> map(Function1<Object, T> f) {
        return ILongArray.map$(this, f);
    }

    @Override
    public PrimitiveIterator.OfLong iterator(long from) {
        return ILongArray.iterator$(this, from);
    }

    @Override
    public long iterator$default$1() {
        return ILongArray.iterator$default$1$(this);
    }

    @Override
    public Exception org$mule$weave$v2$io$TrackingClosable$$closerResponsible() {
        return this.org$mule$weave$v2$io$TrackingClosable$$closerResponsible;
    }

    @Override
    public void org$mule$weave$v2$io$TrackingClosable$$closerResponsible_$eq(Exception x$1) {
        this.org$mule$weave$v2$io$TrackingClosable$$closerResponsible = x$1;
    }

    @Override
    public boolean org$mule$weave$v2$io$TrackingClosable$$closed() {
        return this.org$mule$weave$v2$io$TrackingClosable$$closed;
    }

    @Override
    public void org$mule$weave$v2$io$TrackingClosable$$closed_$eq(boolean x$1) {
        this.org$mule$weave$v2$io$TrackingClosable$$closed = x$1;
    }

    @Override
    public ILongArray$LongArrayIterator$ LongArrayIterator() {
        if (this.LongArrayIterator$module == null) {
            this.LongArrayIterator$lzycompute$1();
        }
        return this.LongArrayIterator$module;
    }

    private File tempFile$lzycompute() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tempFile = this.workingDirectoryService.newBufferFile(BufferFileClassifier$.MODULE$.INDEX());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tempFile;
    }

    public File tempFile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tempFile$lzycompute() : this.tempFile;
    }

    private RandomAccessFile randomAccessFile$lzycompute() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.randomAccessFile = new RandomAccessFile(this.tempFile(), "rw");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.randomAccessFile;
    }

    public RandomAccessFile randomAccessFile() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.randomAccessFile$lzycompute() : this.randomAccessFile;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public void fileSize_$eq(long x$1) {
        this.fileSize = x$1;
    }

    public long _size() {
        return this._size;
    }

    public void _size_$eq(long x$1) {
        this._size = x$1;
    }

    public long bufferOffset() {
        return this.bufferOffset;
    }

    public void bufferOffset_$eq(long x$1) {
        this.bufferOffset = x$1;
    }

    public int bufferLimit() {
        return this.bufferLimit;
    }

    public ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    public long _last() {
        return this._last;
    }

    public void _last_$eq(long x$1) {
        this._last = x$1;
    }

    public int unflushedCount() {
        return this.unflushedCount;
    }

    public void unflushedCount_$eq(int x$1) {
        this.unflushedCount = x$1;
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    private void doClose(boolean async) {
        block0: {
            TrackingClosable.close$(this);
            this.memoryService.release(this.readBuffer(), "index-r");
            this.memoryService.release(this.writeBuffer(), "index-w");
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.randomAccessFile().close());
            boolean deleted = this.workingDirectoryService.releaseBufferFile(this.tempFile(), async);
            if (deleted) break block0;
            PersistedLongArray$.MODULE$.LOGGER().log(Level.WARNING, new StringBuilder(28).append("Unable to delete tmp file: ").append(this.tempFile().getAbsolutePath()).append(".").toString());
        }
    }

    private boolean doClose$default$1() {
        return true;
    }

    public void seekToEOF() {
        this.randomAccessFile().seek(this.fileSize());
    }

    @Override
    public PersistedLongArray $plus$eq(long elem) {
        if (this.unflushedCount() + DefaultLongArray$.MODULE$.LONG_SIZE() > this.bufferLimit()) {
            this.seekToEOF();
            this.flushBuffer();
        }
        this.writeBuffer().putLong(elem);
        this.unflushedCount_$eq(this.unflushedCount() + DefaultLongArray$.MODULE$.LONG_SIZE());
        this._size_$eq(this._size() + 1L);
        this._last_$eq(elem);
        return this;
    }

    @Override
    public PersistedLongArray $plus$plus$eq(long[] elems) {
        block4: {
            this.assertNotClosed();
            if (elems.length <= 0) break block4;
            int elemsSizeInBytes = DefaultLongArray$.MODULE$.LONG_SIZE() * elems.length;
            if (elemsSizeInBytes >= this.bufferLimit()) {
                this.seekToEOF();
                this.flushBuffer();
                byte[] byteArray = this.toByteArray(elems);
                this.randomAccessFile().write(byteArray);
                this.fileSize_$eq(this.fileSize() + (long)byteArray.length);
            } else {
                if (this.unflushedCount() + elemsSizeInBytes > this.bufferLimit()) {
                    this.seekToEOF();
                    this.flushBuffer();
                }
                for (int i = 0; i < elems.length; ++i) {
                    this.writeBuffer().putLong(elems[i]);
                }
                this.unflushedCount_$eq(this.unflushedCount() + elemsSizeInBytes);
            }
            this._size_$eq(this._size() + (long)elems.length);
            this._last_$eq(elems[elems.length - 1]);
        }
        return this;
    }

    public void flushBuffer() {
        block1: {
            if (this.unflushedCount() <= 0) break block1;
            this.writeBuffer().flip();
            int result = 0;
            do {
                result = this.randomAccessFile().getChannel().write(this.writeBuffer());
                this.fileSize_$eq(this.fileSize() + (long)result);
            } while (result > 0);
            this.writeBuffer().clear();
            this.unflushedCount_$eq(0);
        }
    }

    private byte[] toByteArray(long[] value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * value.length);
        byteBuffer.asLongBuffer().put(value);
        return byteBuffer.array();
    }

    @Override
    public void clear() {
        this.writeBuffer().clear();
        this.unflushedCount_$eq(0);
        this.readBuffer().clear();
        this.bufferOffset_$eq(-1L);
        this._size_$eq(0L);
        this._last_$eq(-1L);
        this.randomAccessFile().setLength(0L);
        this.fileSize_$eq(0L);
    }

    @Override
    public void update(long idx, long elem) {
        block2: {
            Object object;
            this.assertNotClosed();
            long indexPosition = idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE();
            long writeBufOffset = this.fileSize();
            boolean insideBuffer = this.isInsideBuffer(indexPosition, writeBufOffset, this.writeBuffer().limit());
            if (insideBuffer) {
                int pos = this.writeBuffer().position();
                this.writeBuffer().position((int)(indexPosition - writeBufOffset));
                this.writeBuffer().asLongBuffer().put(elem);
                object = this.writeBuffer().position(pos);
            } else {
                this.randomAccessFile().seek(idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE());
                this.randomAccessFile().writeLong(elem);
                object = BoxedUnit.UNIT;
            }
            if (idx != this.size() - 1L) break block2;
            this._last_$eq(elem);
        }
    }

    @Override
    public long size() {
        return this._size();
    }

    @Override
    public long last() {
        if (this._last() == -1L) {
            throw new NoSuchElementException();
        }
        return this._last();
    }

    @Override
    public long apply(long idx) {
        long l;
        this.assertNotClosed();
        if (idx == this.size() - 1L) {
            l = this._last();
        } else {
            long result;
            boolean bufferNotInitialized;
            long indexPosition = idx * (long)DefaultLongArray$.MODULE$.LONG_SIZE();
            boolean insideBuffer = this.isInsideBuffer(indexPosition, this.bufferOffset(), this.readBuffer().limit());
            boolean bl = bufferNotInitialized = this.bufferOffset() == -1L;
            if (bufferNotInitialized || !insideBuffer) {
                this.reloadBuffer(indexPosition);
            }
            long bufferPos = indexPosition - this.bufferOffset();
            this.readBuffer().position((int)bufferPos);
            l = result = this.readBuffer().getLong();
        }
        return l;
    }

    private boolean isInsideBuffer(long indexPosition, long bufferOffset, int bufferLimit) {
        return indexPosition >= bufferOffset && indexPosition <= bufferOffset + (long)bufferLimit - (long)DefaultLongArray$.MODULE$.LONG_SIZE();
    }

    public void reloadBuffer(long indexPosition) {
        if (this.unflushedCount() > 0) {
            this.seekToEOF();
            this.flushBuffer();
        }
        int totalBytesRead = 0;
        int result = 0;
        this.readBuffer().clear();
        do {
            result = this.randomAccessFile().getChannel().read(this.readBuffer(), indexPosition + (long)totalBytesRead);
            totalBytesRead += result;
        } while (result > 0);
        this.readBuffer().flip();
        this.bufferOffset_$eq(indexPosition);
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public void finalize() {
        if (!this.isClosed()) {
            Predef$.MODULE$.println((Object)new StringBuilder(119).append("[warning] PersistedLongArray(fileName: `").append(this.tempFile().getName()).append("` is being GCed but is still open. It is going to be closed to avoid tmp leaks.").toString());
            try {
                this.doClose(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        super.finalize();
    }

    private final void LongArrayIterator$lzycompute$1() {
        PersistedLongArray persistedLongArray = this;
        synchronized (persistedLongArray) {
            if (this.LongArrayIterator$module == null) {
                this.LongArrayIterator$module = new ILongArray$LongArrayIterator$(this);
            }
        }
    }

    public PersistedLongArray(WorkingDirectoryService workingDirectoryService, SettingsService settingsService, MemoryService memoryService) {
        this.workingDirectoryService = workingDirectoryService;
        this.memoryService = memoryService;
        ILongArray.$init$(this);
        TrackingClosable.$init$(this);
        this.fileSize = 0L;
        this._size = 0L;
        this.bufferOffset = -1L;
        this.bufferLimit = settingsService.memory().indexSize();
        this.readBuffer = memoryService.take("index-r");
        this.writeBuffer = memoryService.take("index-w");
        this._last = -1L;
        this.unflushedCount = 0;
    }
}

