/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.StreamSourceBufferedCharSequence$;
import org.mule.weave.v2.module.reader.BufferResult;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.reader.UTF8BufferedCharSequenceReader$;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0012%\u0001EB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")a\n\u0001C\u0001\u001f\"A1\u000b\u0001EC\u0002\u0013\u0005A\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\ry\u0003\u0001\u0015!\u0003[\u0011\u001dy\u0006A1A\u0005\neCa\u0001\u0019\u0001!\u0002\u0013Q\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011B2\t\u000f5\u0004!\u0019!C\u0005E\"1a\u000e\u0001Q\u0001\n\rDqa\u001c\u0001A\u0002\u0013\u0005\u0001\u000fC\u0004u\u0001\u0001\u0007I\u0011A;\t\rm\u0004\u0001\u0015)\u0003r\u0011\u0015I\u0005\u0001\"\u0011}\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u00111\u0007\u0001\u0005B\u0005E\u0002bBA\u001b\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a\u0012\u0001\t\u0003\n\u0019\u0003C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!a3\u0001\t\u0003\ni\rC\u0004\u0002T\u0002!\t%!\f\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\n1R\u000b\u0016$9'R\u0014X-Y7T_V\u00148-\u001a*fC\u0012,'O\u0003\u0002&M\u00051!/Z1eKJT!a\n\u0015\u0002\r5|G-\u001e7f\u0015\tI#&\u0001\u0002we)\u00111\u0006L\u0001\u0006o\u0016\fg/\u001a\u0006\u0003[9\nA!\\;mK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ei\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004PE*,7\r\u001e\t\u0003wqj\u0011\u0001J\u0005\u0003{\u0011\u0012AbU8ve\u000e,'+Z1eKJ\fab]3fW\u0006\u0014G.Z*ue\u0016\fW\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002CQ\u0005\u0011\u0011n\\\u0005\u0003\t\u0006\u0013abU3fW\u0006\u0014G.Z*ue\u0016\fW.A\u0006vg\u0016$7\t[1sg\u0016$\bCA$M\u001b\u0005A%BA%K\u0003\u001d\u0019\u0007.\u0019:tKRT!a\u0013\u001c\u0002\u00079Lw.\u0003\u0002N\u0011\n91\t[1sg\u0016$\u0018A\u0002\u001fj]&$h\bF\u0002Q#J\u0003\"a\u000f\u0001\t\u000by\u001a\u0001\u0019A \t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002\u000f\u0011,7m\u001c3feV\tQ\u000b\u0005\u0002H-&\u0011q\u000b\u0013\u0002\u000f\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s\u0003)\u0019\u0007.\u0019:Ck\u001a4WM]\u000b\u00025B\u00111\fX\u0007\u0002\u0015&\u0011QL\u0013\u0002\u000b\u0007\"\f'OQ;gM\u0016\u0014\u0018aC2iCJ\u0014UO\u001a4fe\u0002\n\u0011\u0003Z3gCVdGo\u00115be\n+hMZ3s\u0003I!WMZ1vYR\u001c\u0005.\u0019:Ck\u001a4WM\u001d\u0011\u0002!\u0011,g-Y;mi\nKH/Z!se\u0006LX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0015\t%O]1z!\t!'.\u0003\u0002lK\n!!)\u001f;f\u0003E!WMZ1vYR\u0014\u0015\u0010^3BeJ\f\u0017\u0010I\u0001\u0016I\u00164\u0017-\u001e7u\u0007\"\f'o\u001d\"zi\u0016\f%O]1z\u0003Y!WMZ1vYR\u001c\u0005.\u0019:t\u0005f$X-\u0011:sCf\u0004\u0013AC0sK\u0006$')\u001f;fgV\t\u0011\u000f\u0005\u0002ee&\u00111/\u001a\u0002\u0004\u0013:$\u0018AD0sK\u0006$')\u001f;fg~#S-\u001d\u000b\u0003mf\u0004\"\u0001Z<\n\u0005a,'\u0001B+oSRDqA\u001f\b\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\n1b\u0018:fC\u0012\u0014\u0015\u0010^3tAU\tQ\u0010E\u0002e}\u001aK!a`3\u0003\r=\u0003H/[8o\u0003-\u0019w\u000e]=CsR,7\u000fV8\u0015\u000fY\f)!a\u0004\u0002\u0014!9\u0011qA\tA\u0002\u0005%\u0011!D:uCJ$\bk\\:ji&|g\u000eE\u0002e\u0003\u0017I1!!\u0004f\u0005\u0011auN\\4\t\r\u0005E\u0011\u00031\u0001r\u0003\u0019aWM\\4uQ\"9\u0011QC\tA\u0002\u0005]\u0011A\u0002;be\u001e,G\u000f\u0005\u0003\u0002\u001a\u0005uQBAA\u000e\u0015\t\u0011e'\u0003\u0003\u0002 \u0005m!\u0001D(viB,Ho\u0015;sK\u0006l\u0017!\u0003:fC\u0012\f5oY5j)\t\t)\u0003E\u0002e\u0003OI1!!\u000bf\u0005\u0011\u0019\u0005.\u0019:\u0002\u0013!\fg\u000e\u001a7f\u0005>kE#\u0001<\u0002\u0011A|7/\u001b;j_:$\"!!\u0003\u0002!A\u0014XM^5pkN\u0004vn]5uS>t\u0017A\u00047p_.\f\u0005.Z1e\u0003N\u001c\u0017.[\u0001\u0005g\u0016,7\u000eF\u0002w\u0003wAq!a\f\u0018\u0001\u0004\tI!\u0001\bj]6+Wn\u001c:z%\u0016\fG-\u001a:\u0015\u0005\u0005\u0005\u0003c\u00013\u0002D%\u0019\u0011QI3\u0003\u000f\t{w\u000e\\3b]\u0006!!/Z1e\u0003\u0011\u001a\u0017\r\\2vY\u0006$XMU3nC&t\u0017N\\4CsR,7\u000fV8SK\u0006$gi\u001c:DQ\u0006\u0014HcA9\u0002N!1\u0011q\n\u000eA\u0002%\fAAY=uK\u0006\t\"/Z1e\u000b:\u001cw\u000eZ3e'R\u0014\u0018N\\4\u0015\r\u0005U\u00131NA8!\u0011\t9&!\u001a\u000f\t\u0005e\u0013\u0011\r\t\u0004\u00037*WBAA/\u0015\r\ty\u0006M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rT-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\nIG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003G*\u0007bBA77\u0001\u0007\u0011\u0011B\u0001\u0005MJ|W\u000eC\u0004\u0002\u0012m\u0001\r!!\u0003\u0002/I,\u0017\rZ#oG>$W\rZ\"iCJ\u001cV-];f]\u000e,GCBA;\u0003\u001b\u000b\t\n\u0006\u0003\u0002x\u0005u\u0004cA\u001a\u0002z%\u0019\u00111\u0010\u001b\u0003\u0019\rC\u0017M]*fcV,gnY3\t\u000f\u0005}D\u0004q\u0001\u0002\u0002\u0006\u00191\r\u001e=\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\")\u0003\u0015iw\u000eZ3m\u0013\u0011\tY)!\"\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0004\u0002\u0010r\u0001\r!!\u0003\u0002\r=4gm]3u\u0011\u001d\t\t\u0002\ba\u0001\u0003\u0013\t\u0011D]3bI\u0016s7m\u001c3fI\u000eC\u0017M]:V]RLGnU5{KRA\u0011QKAL\u00033\u000bY\nC\u0004\u0002\u0010v\u0001\r!!\u0003\t\u000f\u0005EQ\u00041\u0001\u0002\n!1\u0011QT\u000fA\u0002E\f1b\u00195beN$vNU3bI\u0006!\"/Z1e\u0005f$Xm]+oi&dgj\u00115beN$\"\"a)\u0002*\u0006-\u0016QVAX!\u0015!\u0017QU9d\u0013\r\t9+\u001a\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005=e\u00041\u0001\u0002\n!9\u0011\u0011\u0003\u0010A\u0002\u0005%\u0001BBAO=\u0001\u0007\u0011\u000f\u0003\u0004\u00022z\u0001\raY\u0001\u0007EV4g-\u001a:\u0002\u001d\r|WO\u001c;DQ\u0006\u00148OU3bIRa\u0011qWA_\u0003\u007f\u000b\t-a1\u0002HB\u00191(!/\n\u0007\u0005mFE\u0001\u0007Ck\u001a4WM\u001d*fgVdG\u000fC\u0004\u0002\u0010~\u0001\r!!\u0003\t\u000f\u0005Eq\u00041\u0001\u0002\n!1\u0011\u0011W\u0010A\u0002\rDa!!2 \u0001\u0004\t\u0018a\u00032vM\u001a,'/\u00138eKbDa!!3 \u0001\u0004\t\u0018\u0001\u00042vM\u001a,'\u000fT3oORD\u0017a\u0004:fC\u0012\f5oY5j'R\u0014\u0018N\\4\u0015\r\u0005U\u0013qZAi\u0011\u001d\ti\u0007\ta\u0001\u0003\u0013Aq!!\u0005!\u0001\u0004\tI!A\u0003dY>\u001cX-A\u0006jg\nKH/\u001a\"bg\u0016$WCAA!\u0001")
public class UTF8StreamSourceReader
implements SourceReader {
    private CharsetDecoder decoder;
    private final SeekableStream seekableStream;
    private final Charset usedCharset;
    private final CharBuffer charBuffer;
    private final CharBuffer defaultCharBuffer;
    private final byte[] defaultByteArray;
    private final byte[] defaultCharsByteArray;
    private int _readBytes;
    private volatile boolean bitmap$0;

    @Override
    public boolean supportsSeek() {
        return SourceReader.supportsSeek$(this);
    }

    @Override
    public boolean requireClose() {
        return SourceReader.requireClose$(this);
    }

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.usedCharset.newDecoder();
                this.bitmap$0 = true;
            }
        }
        return this.decoder;
    }

    public CharsetDecoder decoder() {
        return !this.bitmap$0 ? this.decoder$lzycompute() : this.decoder;
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer defaultCharBuffer() {
        return this.defaultCharBuffer;
    }

    private byte[] defaultByteArray() {
        return this.defaultByteArray;
    }

    private byte[] defaultCharsByteArray() {
        return this.defaultCharsByteArray;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public Option<Charset> charset() {
        return new Some((Object)this.usedCharset);
    }

    @Override
    public void copyBytesTo(long startPosition, int length, OutputStream target) {
        int amountRead;
        this.seekableStream.seek(startPosition);
        for (int totalRead = 0; totalRead < length; totalRead += amountRead) {
            int minLength = Math.min(this.defaultByteArray().length, length - totalRead);
            amountRead = ((InputStream)((Object)this.seekableStream)).read(this.defaultByteArray(), 0, minLength);
            target.write(this.defaultByteArray(), 0, amountRead);
        }
    }

    @Override
    public char readAscii() {
        char c;
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            c = (char)(read & 0xFF);
        } else {
            this._readBytes_$eq(0);
            c = '\uffff';
        }
        return c;
    }

    public void handleBOM() {
        block0: {
            Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.usedCharset);
            byte[] bom = (byte[])mayBeBom.get();
            byte[] inputBom = new byte[bom.length];
            ((InputStream)((Object)this.seekableStream)).read(inputBom);
            if (inputBom[0] == bom[0] && inputBom[1] == bom[1] && inputBom[2] == bom[2]) break block0;
            this.seekableStream.seek(0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position() {
        long l;
        long position = this.seekableStream.position();
        if (position == 0L) {
            this.handleBOM();
            l = this.seekableStream.position();
        } else {
            void var1_1;
            l = var1_1;
        }
        return l;
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
        }
        finally {
            this.seek(startPosition);
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public boolean inMemoryReader() {
        return this.seekableStream.inMemoryStream();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char read() {
        int n;
        if (this.charBuffer().position() == this.charBuffer().length()) {
            n = this.charBuffer().get();
        } else {
            byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
            if (_read == -1) {
                this._readBytes_$eq(0);
                n = 65535;
            } else {
                void var3_4;
                char c;
                int remainingBytes;
                int n2 = remainingBytes = this.calculateRemainingBytesToReadForChar(_read);
                switch (n2) {
                    case -1: {
                        c = 65533;
                        break;
                    }
                    case 0: {
                        this._readBytes_$eq(1);
                        c = (char)_read;
                        break;
                    }
                    default: {
                        this._readBytes_$eq(remainingBytes + 1);
                        c = this.decode$1(_read, remainingBytes);
                        break;
                    }
                }
                int charRead = c;
                n = var3_4;
            }
        }
        return (char)n;
    }

    private int calculateRemainingBytesToReadForChar(byte by) {
        return by >= 0 ? 0 : ((by & 0xE0) == 192 ? 1 : ((by & 0xF0) == 224 ? 2 : ((by & 0xF8) == 240 ? 3 : -1)));
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if (amount == -1) {
            throw new IllegalArgumentException(new StringBuilder(85).append("The end of the stream has been reached while reading encoded string from: ").append(from).append(", length: ").append(length).append(".").toString());
        }
        CharBuffer charBuffer = (long)this.defaultCharBuffer().capacity() < length ? CharBuffer.allocate((int)length) : this.defaultCharBuffer();
        charBuffer.clear();
        this.decoder().decode(ByteBuffer.wrap(bytes, 0, amount), charBuffer, true);
        int decodedLength = charBuffer.position();
        return new String(charBuffer.array(), 0, decodedLength);
    }

    @Override
    public CharSequence readEncodedCharSequence(long offset, long length, EvaluationContext ctx) {
        return ctx.serviceManager().settingsService().bufferedCharSequence().enabled() ? (length <= (long)ctx.serviceManager().settingsService().memory().maxMemoryAllocation() ? this.readEncodedString(offset, length) : StreamSourceBufferedCharSequence$.MODULE$.apply(UTF8BufferedCharSequenceReader$.MODULE$.apply(this, offset, length))) : this.readEncodedString(offset, length);
    }

    public String readEncodedCharsUntilSize(long offset, long length, int charsToRead) {
        byte[] buffer = (long)this.defaultCharsByteArray().length > length ? this.defaultCharsByteArray() : new byte[charsToRead * 4];
        Tuple2<Object, byte[]> tuple2 = this.readBytesUntilNChars(offset, length, charsToRead, buffer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesLength = tuple2._1$mcI$sp();
        byte[] bytesRead = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesLength), (Object)bytesRead);
        Tuple2 tuple23 = tuple22;
        int bytesLength2 = tuple23._1$mcI$sp();
        byte[] bytesRead2 = (byte[])tuple23._2();
        CharBuffer charBuffer = this.defaultCharBuffer().capacity() < charsToRead ? CharBuffer.allocate(charsToRead) : this.defaultCharBuffer();
        charBuffer.clear();
        this.decoder().decode(ByteBuffer.wrap(bytesRead2, 0, bytesLength2), charBuffer, true);
        int decodedLength = charBuffer.position();
        return new String(charBuffer.array(), 0, decodedLength);
    }

    private Tuple2<Object, byte[]> readBytesUntilNChars(long offset, long length, int charsToRead, byte[] buffer) {
        Tuple2 tuple2;
        this.seek(offset);
        if (length <= (long)charsToRead) {
            int lengthToRead = (int)length;
            int amount = ((InputStream)((Object)this.seekableStream)).read(buffer, 0, lengthToRead);
            if (amount == -1) {
                throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset).append(", length: ").append(length).append(".").toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)lengthToRead), (Object)buffer);
        } else {
            tuple2 = this.loop$1(length, 0, charsToRead, buffer, 0, 0, charsToRead, offset, length);
        }
        return tuple2;
    }

    private BufferResult countCharsRead(long offset, long length, byte[] buffer, int bufferIndex, int bufferLength) {
        int charsCount = 0;
        int remainingBytes = 0;
        int index = bufferIndex;
        while (index < bufferLength) {
            byte by = buffer[index];
            int remaining = this.calculateRemainingBytesToReadForChar(by);
            if (remaining == -1) {
                throw new IllegalArgumentException(new StringBuilder(77).append("An error char has been reached while reading encoded chars offset: ").append(offset).append(", length: ").append(length).toString());
            }
            remainingBytes += remaining;
            index += remaining + 1;
            ++charsCount;
        }
        return new BufferResult(index, remainingBytes, charsCount);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if (amount == -1) {
            throw new IllegalArgumentException(new StringBuilder(83).append("The end of the stream has been reached while reading ascii string from: ").append(from).append(", length: ").append(length).append(".").toString());
        }
        return new String(bytes, 0, amount, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        this.seekableStream.close();
    }

    @Override
    public boolean isByteBased() {
        return true;
    }

    private final char decode$1(byte by, int remainingBytes) {
        char c;
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        int amountThatWasRead = ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        CoderResult result = this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), true);
        if (!result.isError()) {
            try {
                this.charBuffer().flip();
                c = this.charBuffer().get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.seek(this.position() - (long)amountThatWasRead);
                c = this.read();
            }
        } else {
            this.seek(this.position() - (long)amountThatWasRead);
            c = this.read();
        }
        return c;
    }

    private final Tuple2 loop$1(long remaining, int charsRead, int bytesToRead, byte[] buffer, int bufferOffset, int bufferIndex, int charsToRead$1, long offset$1, long length$1) {
        while (true) {
            if (charsRead == charsToRead$1 || remaining == 0L) {
                int bytes;
                int amount;
                if (bytesToRead != 0 && (amount = ((InputStream)((Object)this.seekableStream)).read(buffer, bufferOffset, bytes = (int)Math.min(remaining, (long)bytesToRead))) == -1) {
                    throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset$1).append(", length: ").append(length$1).append(".").toString());
                }
                break;
            }
            int bytes = (int)Math.min(remaining, (long)bytesToRead);
            int amount = ((InputStream)((Object)this.seekableStream)).read(buffer, bufferOffset, bytes);
            if (amount == -1) {
                throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset$1).append(", length: ").append(length$1).append(".").toString());
            }
            int bufferLength = bufferOffset + bytes;
            BufferResult result = this.countCharsRead(offset$1, length$1, buffer, bufferIndex, bufferLength);
            bufferIndex = result.bufferIndex();
            bufferOffset = bufferLength;
            bytesToRead = result.remainingBytes();
            charsRead += result.charsCount();
            remaining -= (long)bytes;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(bufferOffset + bytesToRead)), (Object)buffer);
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset usedCharset) {
        this.seekableStream = seekableStream;
        this.usedCharset = usedCharset;
        SourceReader.$init$(this);
        this.charBuffer = CharBuffer.allocate(2);
        this.defaultCharBuffer = CharBuffer.allocate(8192);
        this.defaultByteArray = new byte[8192];
        this.defaultCharsByteArray = new byte[16384];
        this._readBytes = 0;
    }
}

