/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.utils;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

class ClassNameResolverVisitor
extends MetadataTypeVisitor {
    private String typeName = null;

    ClassNameResolverVisitor() {
    }

    public Optional<String> getTypeName() {
        return Optional.ofNullable(this.typeName);
    }

    @Override
    public void visitNull(NullType nullType) {
        this.typeName = Void.TYPE.getName();
    }

    @Override
    public void visitVoid(VoidType voidType) {
        this.typeName = Void.TYPE.getName();
    }

    @Override
    public void defaultVisit(MetadataType metadataType) {
        this.typeName = this.findFromAnnotations(metadataType).orElse(null);
    }

    @Override
    public void visitAnyType(AnyType anyType) {
        this.typeName = this.findFromAnnotations(anyType).orElse(Object.class.getName());
    }

    @Override
    public void visitBoolean(BooleanType booleanType) {
        this.typeName = MetadataTypeUtils.getTypeId(booleanType).orElse(Boolean.TYPE.getName());
    }

    @Override
    public void visitNumber(NumberType numberType) {
        this.typeName = this.findFromAnnotations(numberType).orElse(numberType.getAnnotation(IntAnnotation.class).map(a -> Integer.class.getName()).orElse(null));
    }

    @Override
    public void visitString(StringType stringType) {
        this.typeName = stringType.getAnnotation(EnumAnnotation.class).isPresent() ? MetadataTypeUtils.getTypeId(stringType).orElseGet(() -> stringType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getClassname).orElse(String.class.getName())) : (stringType.getAnnotation(ClassInformationAnnotation.class).isPresent() ? stringType.getAnnotation(ClassInformationAnnotation.class).get().getClassname() : String.class.getName());
    }

    @Override
    public void visitObjectField(ObjectFieldType objectFieldType) {
        objectFieldType.getValue().accept(this);
    }

    @Override
    public void visitArrayType(ArrayType arrayType) {
        this.typeName = this.findFromAnnotations(arrayType).orElse(List.class.getName());
    }

    private Optional<String> findFromAnnotations(MetadataType type) {
        Optional<String> classInfo = type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getClassname);
        return classInfo.isPresent() ? classInfo : MetadataTypeUtils.getTypeId(type);
    }
}

