/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.example;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.example.HandlerManager;
import org.mule.metadata.json.api.example.JsonElementHandler;
import org.mule.metadata.json.api.example.ParsingContext;

public class ArrayHandler
implements JsonElementHandler {
    @Override
    public boolean handles(JsonElement jsonElement) {
        return jsonElement.isJsonArray();
    }

    @Override
    public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        JsonArray array = (JsonArray)jsonElement;
        ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
        parsingContext.getAnnotations().forEach(arrayMetadataBuilder::with);
        JsonElement arraySample = this.getFirstChild(array);
        if (arraySample != null) {
            LinkedHashMap builders = new LinkedHashMap();
            for (JsonElement item : array) {
                TypeBuilder<?> itemBuilder = handlerManager.handle(item, new ParsingContext(parsingContext.getHandlerConfiguration()));
                Object type = itemBuilder.build();
                if (builders.containsKey(type)) continue;
                builders.put((MetadataType)type, itemBuilder);
            }
            if (builders.size() > 1) {
                if (parsingContext.getHandlerConfiguration().isMergeObjectUnionTypes() && this.allChildBuilderAreObjectBuilders(builders)) {
                    JsonElement mergedArrayExample = this.mergeExamples(array);
                    arrayMetadataBuilder.of(handlerManager.handle(mergedArrayExample, new ParsingContext(parsingContext.getHandlerConfiguration())));
                } else {
                    UnionTypeBuilder unionTypeBuilder = arrayMetadataBuilder.of().unionType();
                    builders.values().forEach(unionTypeBuilder::of);
                }
            } else {
                arrayMetadataBuilder.of(handlerManager.handle(arraySample, new ParsingContext(parsingContext.getHandlerConfiguration())));
            }
        } else {
            arrayMetadataBuilder.of().anyType();
        }
        return arrayMetadataBuilder;
    }

    private boolean allChildBuilderAreObjectBuilders(Map<MetadataType, TypeBuilder<?>> builders) {
        return builders.values().stream().allMatch(ObjectTypeBuilder.class::isInstance);
    }

    private JsonElement getFirstChild(JsonArray array) {
        Iterator i = array.iterator();
        if (i.hasNext()) {
            return (JsonElement)i.next();
        }
        return null;
    }

    private JsonElement mergeExamples(JsonArray array) {
        JsonObject innerObject = new JsonObject();
        HashSet properties = new HashSet();
        for (JsonObject item : array) {
            item.entrySet().stream().forEach(field -> {
                String property = (String)field.getKey();
                if (!properties.contains(property)) {
                    properties.add(property);
                    innerObject.add(property, (JsonElement)field.getValue());
                }
            });
        }
        return innerObject;
    }
}

