/*
 * Decompiled with CFR 0.152.
 */
package org.mule.oauth.client.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.oauth.client.api.AuthorizationCodeOAuthDancer;
import org.mule.oauth.client.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.oauth.client.api.exception.RequestAuthenticationException;
import org.mule.oauth.client.api.exception.TokenNotFoundException;
import org.mule.oauth.client.api.exception.TokenUrlResponseException;
import org.mule.oauth.client.api.listener.AuthorizationCodeListener;
import org.mule.oauth.client.api.listener.OAuthStateListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.oauth.client.internal.AbstractOAuthDancer;
import org.mule.oauth.client.internal.authorizationcode.AuthorizationRequestUrlBuilder;
import org.mule.oauth.client.internal.authorizationcode.DefaultAuthorizationCodeRequest;
import org.mule.oauth.client.internal.config.DefaultAuthorizationCodeOAuthDancerConfig;
import org.mule.oauth.client.internal.state.StateDecoder;
import org.mule.oauth.client.internal.state.StateEncoder;
import org.mule.oauth.client.internal.state.TokenResponse;
import org.mule.oauth.client.internal.util.ClassLoaderUtils;
import org.mule.oauth.client.internal.util.IOUtils;
import org.mule.oauth.client.internal.util.MultiMapUtils;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationCodeOAuthDancer
extends AbstractOAuthDancer<DefaultAuthorizationCodeOAuthDancerConfig>
implements AuthorizationCodeOAuthDancer,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationCodeOAuthDancer.class);
    private RequestHandlerManager redirectUrlHandlerManager;
    private RequestHandlerManager localAuthorizationUrlHandlerManager;
    Map<String, CopyOnWriteArrayList<OAuthStateListener>> resourceOwnerListeners = new ConcurrentHashMap<String, CopyOnWriteArrayList<OAuthStateListener>>();

    public DefaultAuthorizationCodeOAuthDancer(DefaultAuthorizationCodeOAuthDancerConfig config) {
        super(config);
    }

    @Override
    public void initialise() throws InitialisationException {
        ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().ifPresent(s -> {
            this.redirectUrlHandlerManager = DefaultAuthorizationCodeOAuthDancer.addRequestHandler(s, HttpConstants.Method.GET, ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getLocalCallbackUrlPath(), this.createRedirectUrlListener());
            this.localAuthorizationUrlHandlerManager = DefaultAuthorizationCodeOAuthDancer.addRequestHandler(s, HttpConstants.Method.GET, ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getLocalAuthorizationUrlPath(), this.createLocalAuthorizationUrlListener());
        });
    }

    @Override
    public void addListener(AuthorizationCodeListener listener) {
        this.doAddListener(listener);
    }

    @Override
    public void removeListener(AuthorizationCodeListener listener) {
        this.doRemoveListener(listener);
    }

    @Override
    public void addListener(String resourceOwnerId, AuthorizationCodeListener listener) {
        CopyOnWriteArrayList listeners = this.resourceOwnerListeners.computeIfAbsent(resourceOwnerId, k -> new CopyOnWriteArrayList());
        listeners.add(listener);
    }

    @Override
    public void removeListener(String resourceOwnerId, AuthorizationCodeListener listener) {
        List listeners = this.resourceOwnerListeners.get(resourceOwnerId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private static RequestHandlerManager addRequestHandler(HttpServer server, HttpConstants.Method method, String path, final RequestHandler callbackHandler) {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        RequestHandler requestHandler = new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                Thread thread = Thread.currentThread();
                ClassLoader currentClassLoader = thread.getContextClassLoader();
                ClassLoader contextClassLoader = DefaultAuthorizationCodeOAuthDancer.class.getClassLoader();
                ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
                try {
                    callbackHandler.handleRequest(requestContext, responseCallback);
                }
                catch (Exception e) {
                    LOGGER.error("Uncaught Exception on OAuth listener", (Throwable)e);
                    DefaultAuthorizationCodeOAuthDancer.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), responseCallback);
                }
                finally {
                    ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
                }
            }

            @Override
            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
        return server.addRequestHandler(Collections.singleton(method.name()), path, requestHandler);
    }

    private static void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
        responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(status.getStatusCode()).reasonPhrase(status.getReasonPhrase()).entity(message != null ? new ByteArrayHttpEntity(message.getBytes()) : new EmptyHttpEntity())).addHeader("Content-Length", message != null ? String.valueOf(message.length()) : "0")).build(), new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            @Override
            public void responseSendSuccessfully() {
            }
        });
    }

    private RequestHandler createRedirectUrlListener() {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        return new RequestHandler(){

            @Override
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                HttpRequest request = requestContext.getRequest();
                MultiMap<String, String> queryParams = request.getQueryParams();
                String state = queryParams.get("state");
                StateDecoder stateDecoder = new StateDecoder(state);
                String authorizationCode = queryParams.get("code");
                String resourceOwnerId = stateDecoder.decodeResourceOwnerId();
                if (authorizationCode == null) {
                    LOGGER.info("HTTP Request to redirect URL done by the OAuth provider does not contains a code query parameter. Code query parameter is required to get the access token.");
                    LOGGER.error("Could not extract authorization code from OAuth provider HTTP request done to the redirect URL");
                    DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.BAD_REQUEST, "Failure retrieving access token.\n OAuth Server uri from callback: " + String.valueOf(request.getUri()), 100);
                    return;
                }
                AuthorizationCodeDanceCallbackContext beforeCallbackContext = ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getBeforeDanceCallback().apply(new DefaultAuthorizationCodeRequest(resourceOwnerId, ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getAuthorizationUrl(), ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getTokenUrl(), ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getCredentialConfig().getClientId(), ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getCredentialConfig().getClientSecret(), ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getScopes(), stateDecoder.decodeOriginalState()));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Redirect url request state: " + state);
                    LOGGER.debug("Redirect url request code: " + authorizationCode);
                }
                HashMap<String, String> formData = new HashMap<String, String>();
                formData.put("code", authorizationCode);
                String authorization = DefaultAuthorizationCodeOAuthDancer.this.handleClientCredentials(formData);
                formData.put("grant_type", "authorization_code");
                formData.put("redirect_uri", ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getExternalCallbackUrl());
                formData.putAll(((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getCustomBodyParameters().get());
                ((CompletableFuture)DefaultAuthorizationCodeOAuthDancer.this.invokeTokenUrl(((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getTokenUrl(), formData, MultiMap.emptyMultiMap(), new MultiMap<String, String>(((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getCustomHeaders().get()), authorization, true, ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getEncoding()).exceptionally(e -> {
                    Thread thread = Thread.currentThread();
                    ClassLoader currentClassLoader = thread.getContextClassLoader();
                    ClassLoader contextClassLoader = DefaultAuthorizationCodeOAuthDancer.class.getClassLoader();
                    ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
                    try {
                        if (e.getCause() instanceof TokenUrlResponseException) {
                            LOGGER.error(e.getMessage());
                            DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failure calling token url %s. Exception message is %s", ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getTokenUrl(), e.getMessage()), 200);
                        } else if (e.getCause() instanceof TokenNotFoundException) {
                            LOGGER.error(e.getMessage());
                            DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, "Failed getting access token or refresh token from token URL response. See logs for details.", 201);
                        } else {
                            LOGGER.error("Uncaught Exception on OAuth listener", e);
                            DefaultAuthorizationCodeOAuthDancer.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), responseCallback);
                        }
                    }
                    finally {
                        ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
                    }
                    return null;
                })).thenAccept(tokenResponse -> {
                    Thread thread = Thread.currentThread();
                    ClassLoader currentClassLoader = thread.getContextClassLoader();
                    ClassLoader contextClassLoader = DefaultAuthorizationCodeOAuthDancer.class.getClassLoader();
                    ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
                    try {
                        if (tokenResponse == null) {
                            return;
                        }
                        ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext = (ResourceOwnerOAuthContextWithRefreshState)DefaultAuthorizationCodeOAuthDancer.this.getContextForResourceOwner(resourceOwnerId == null ? "default" : resourceOwnerId);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Update OAuth Context for resourceOwnerId %s", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
                            LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
                        }
                        DefaultAuthorizationCodeOAuthDancer.this.updateResourceOwnerState(resourceOwnerOAuthContext, stateDecoder.decodeOriginalState(), (TokenResponse)tokenResponse);
                        DefaultAuthorizationCodeOAuthDancer.this.updateResourceOwnerOAuthContext(resourceOwnerOAuthContext);
                        DefaultAuthorizationCodeOAuthDancer.this.updateResourceOwnerListener(resourceOwnerOAuthContext, l -> l.onAuthorizationCompleted(resourceOwnerOAuthContext));
                        ((DefaultAuthorizationCodeOAuthDancerConfig)DefaultAuthorizationCodeOAuthDancer.this.config).getAfterDanceCallback().accept(beforeCallbackContext, resourceOwnerOAuthContext);
                        DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.OK, "Successfully retrieved access token", 0);
                    }
                    finally {
                        ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
                    }
                });
            }

            @Override
            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
    }

    private void sendResponse(StateDecoder stateDecoder, HttpResponseReadyCallback responseCallback, HttpConstants.HttpStatus statusEmptyState, String message, int authorizationStatus) {
        String onCompleteRedirectToValue = stateDecoder.decodeOnCompleteRedirectTo();
        if (!DefaultAuthorizationCodeOAuthDancer.isEmpty(onCompleteRedirectToValue)) {
            this.sendResponse(responseCallback, HttpConstants.HttpStatus.MOVED_TEMPORARILY, message, HttpEncoderDecoderUtils.appendQueryParam(onCompleteRedirectToValue, "authorizationStatus", String.valueOf(authorizationStatus)));
        } else {
            DefaultAuthorizationCodeOAuthDancer.sendResponse(responseCallback, statusEmptyState, message);
        }
    }

    private void sendResponse(HttpResponseReadyCallback responseCallback, final HttpConstants.HttpStatus status, String message, String locationHeader) {
        HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
        httpResponseBuilder.statusCode(status.getStatusCode());
        httpResponseBuilder.reasonPhrase(status.getReasonPhrase());
        httpResponseBuilder.entity(new ByteArrayHttpEntity(message.getBytes()));
        httpResponseBuilder.addHeader("Content-Length", String.valueOf(message.length()));
        httpResponseBuilder.addHeader("Location", locationHeader);
        httpResponseBuilder.headers(new MultiMap<String, String>(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getCustomHeaders().get()));
        responseCallback.responseReady(httpResponseBuilder.build(), new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            @Override
            public void responseSendSuccessfully() {
            }
        });
    }

    private static void sendResponse(HttpResponseReadyCallback responseCallback, final HttpConstants.HttpStatus status, String message) {
        HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
        httpResponseBuilder.statusCode(status.getStatusCode());
        httpResponseBuilder.reasonPhrase(status.getReasonPhrase());
        httpResponseBuilder.entity(new ByteArrayHttpEntity(message.getBytes()));
        httpResponseBuilder.addHeader("Content-Length", String.valueOf(message.length()));
        responseCallback.responseReady(httpResponseBuilder.build(), new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            @Override
            public void responseSendSuccessfully() {
            }
        });
    }

    private static boolean isEmpty(String value) {
        return value == null || StringUtils.isEmpty((CharSequence)value) || "null".equals(value);
    }

    private RequestHandler createLocalAuthorizationUrlListener() {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        return new RequestHandler(){

            @Override
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                DefaultAuthorizationCodeOAuthDancer.this.handleLocalAuthorizationRequest(requestContext.getRequest(), responseCallback);
            }

            @Override
            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
    }

    @Override
    public void handleLocalAuthorizationRequest(HttpRequest request, HttpResponseReadyCallback responseCallback) {
        String onCompleteRedirectToValue;
        String body = this.readBody(request);
        MultiMap<String, String> headers = this.readHeaders(request);
        MediaType mediaType = this.getMediaType(request);
        MultiMap<String, String> queryParams = request.getQueryParams();
        String originalState = (String)this.resolveExpression(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getState(), body, headers, queryParams, mediaType);
        StateEncoder stateEncoder = new StateEncoder(originalState);
        String resourceOwnerId = (String)this.resolveExpression(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getLocalAuthorizationUrlResourceOwnerId(), body, headers, queryParams, mediaType);
        if (resourceOwnerId != null) {
            stateEncoder.encodeResourceOwnerIdInState(resourceOwnerId);
        }
        if ((onCompleteRedirectToValue = queryParams.get("onCompleteRedirectTo")) != null) {
            stateEncoder.encodeOnCompleteRedirectToInState(onCompleteRedirectToValue);
        }
        String authorizationUrlWithParams = new AuthorizationRequestUrlBuilder().setAuthorizationUrl(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getAuthorizationUrl()).setClientId(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getCredentialConfig().getClientId()).setClientSecret(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getCredentialConfig().getClientSecret()).setCustomParameters(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getCustomParameters().get()).setRedirectUrl(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getExternalCallbackUrl()).setState(stateEncoder.getEncodedState()).setScope(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getScopes()).setEncoding(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getEncoding()).buildUrl();
        this.sendResponse(responseCallback, HttpConstants.HttpStatus.MOVED_TEMPORARILY, body, authorizationUrlWithParams);
    }

    private String readBody(HttpRequest request) {
        return IOUtils.toString(request.getEntity().getContent());
    }

    private MultiMap<String, String> readHeaders(HttpRequest request) {
        return request.getHeaders();
    }

    private MediaType getMediaType(HttpRequest request) {
        String contentType = request.getHeaderValue("Content-Type");
        return contentType != null ? MediaType.parse(contentType) : MediaType.ANY;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().isPresent()) {
            try {
                ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().get().start();
            }
            catch (IOException e) {
                throw new DefaultMuleException(e);
            }
            this.redirectUrlHandlerManager.start();
            this.localAuthorizationUrlHandlerManager.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().isPresent()) {
            this.redirectUrlHandlerManager.stop();
            this.localAuthorizationUrlHandlerManager.stop();
            ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().get().stop();
        }
        super.stop();
    }

    @Override
    public boolean getInvalidateFromTokensStore(String resourceOwner) {
        return super.getInvalidateFromTokensStore(resourceOwner);
    }

    @Override
    public void dispose() {
        if (((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().isPresent()) {
            this.redirectUrlHandlerManager.dispose();
            this.localAuthorizationUrlHandlerManager.dispose();
            ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getHttpServer().get().dispose();
        }
    }

    @Override
    public CompletableFuture<String> accessToken(String resourceOwner) throws RequestAuthenticationException {
        String accessToken = this.getContextForResourceOwner(resourceOwner).getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage(String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    @Override
    public CompletableFuture<Void> refreshToken(String resourceOwner) {
        return this.refreshToken(resourceOwner, false);
    }

    @Override
    public CompletableFuture<Void> refreshToken(String resourceOwner, boolean useQueryParameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing refresh token for user " + resourceOwner);
        }
        return this.doRefreshToken(() -> this.getContextForResourceOwner(resourceOwner), ctx -> this.doRefreshTokenRequest(useQueryParameters, (ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    protected CompletableFuture<Void> doRefreshTokenRequest(boolean useQueryParameters, ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext) {
        Map<String, String> formData;
        MultiMap<String, String> queryParams;
        String userRefreshToken = resourceOwnerOAuthContext.getRefreshToken();
        if (userRefreshToken == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("The user with user id %s has no refresh token in his OAuth state so we can't execute the refresh token call", resourceOwnerOAuthContext.getResourceOwnerId()));
        }
        MultiMap<String, String> requestParameters = new MultiMap<String, String>();
        requestParameters.put("refresh_token", userRefreshToken);
        String authorization = this.handleClientCredentials(requestParameters);
        requestParameters.put("grant_type", "refresh_token");
        if (((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getIncludeRedirectUriInRefreshTokenRequest()) {
            requestParameters.put("redirect_uri", ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getExternalCallbackUrl());
        }
        MultiMapUtils.putAll(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getAdditionalRefreshTokenRequestParameters(), requestParameters);
        if (useQueryParameters) {
            queryParams = requestParameters;
            formData = Collections.emptyMap();
        } else {
            queryParams = MultiMap.emptyMultiMap();
            formData = requestParameters;
        }
        return ((CompletableFuture)this.invokeTokenUrl(((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getTokenUrl(), formData, queryParams, ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getAdditionalRefreshTokenHeaders(), authorization, true, ((DefaultAuthorizationCodeOAuthDancerConfig)this.config).getEncoding()).thenAccept(tokenResponse -> {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassLoader contextClassLoader = DefaultAuthorizationCodeOAuthDancer.class.getClassLoader();
            ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Update OAuth Context for resourceOwnerId {}", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
                }
                this.updateResourceOwnerState(resourceOwnerOAuthContext, null, (TokenResponse)tokenResponse);
                this.updateOAuthContextAfterTokenResponse(resourceOwnerOAuthContext);
                this.updateResourceOwnerListener(resourceOwnerOAuthContext, l -> l.onTokenRefreshed(resourceOwnerOAuthContext));
            }
            finally {
                ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
            }
        })).exceptionally(this.tokenUrlExceptionHandler(resourceOwnerOAuthContext));
    }

    private void updateResourceOwnerState(ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext, String newState, TokenResponse tokenResponse) {
        resourceOwnerOAuthContext.setAccessToken(tokenResponse.getAccessToken());
        if (tokenResponse.getRefreshToken() != null) {
            resourceOwnerOAuthContext.setRefreshToken(tokenResponse.getRefreshToken());
        }
        resourceOwnerOAuthContext.setExpiresIn(tokenResponse.getExpiresIn());
        if (newState != null) {
            resourceOwnerOAuthContext.setState(newState);
        }
        Map<String, Object> customResponseParameters = tokenResponse.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            Object paramValue = customResponseParameters.get(paramName);
            if (paramValue == null) continue;
            resourceOwnerOAuthContext.getTokenResponseParameters().put(paramName, paramValue);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("New OAuth State for resourceOwnerId %s is: accessToken(%s), refreshToken(%s), expiresIn(%s), state(%s)", new Object[]{resourceOwnerOAuthContext.getResourceOwnerId(), resourceOwnerOAuthContext.getAccessToken(), StringUtils.isBlank((CharSequence)resourceOwnerOAuthContext.getRefreshToken()) ? "Not issued" : resourceOwnerOAuthContext.getRefreshToken(), resourceOwnerOAuthContext.getExpiresIn(), resourceOwnerOAuthContext.getState()});
        }
    }

    private void updateResourceOwnerListener(ResourceOwnerOAuthContext resourceOwnerOAuthContext, Consumer<AuthorizationCodeListener> action) {
        if (this.resourceOwnerListeners.containsKey(resourceOwnerOAuthContext.getResourceOwnerId())) {
            this.onEachListener((List<OAuthStateListener>)this.resourceOwnerListeners.get(resourceOwnerOAuthContext.getResourceOwnerId()), l -> action.accept((AuthorizationCodeListener)l));
        }
        this.onEachListener(l -> action.accept((AuthorizationCodeListener)l));
    }

    @Override
    protected List<? extends OAuthStateListener> getListenersToNotifyInvalidation(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        CopyOnWriteArrayList<OAuthStateListener> tmp = new CopyOnWriteArrayList<OAuthStateListener>(super.getListenersToNotifyInvalidation(resourceOwnerOAuthContext));
        if (resourceOwnerOAuthContext != null && this.resourceOwnerListeners.containsKey(resourceOwnerOAuthContext.getResourceOwnerId())) {
            tmp.addAll((Collection<OAuthStateListener>)this.resourceOwnerListeners.get(resourceOwnerOAuthContext.getResourceOwnerId()));
        }
        return tmp;
    }
}

