/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.Experimental;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.metadata.descriptor.BaseInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.BaseInputMetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.util.Preconditions;

@Experimental
public final class RouterInputMetadataDescriptor
extends BaseInputMetadataDescriptor {
    private final Map<String, MessageMetadataType> routeInputMessageTypes;

    private RouterInputMetadataDescriptor(Map<String, ParameterMetadataDescriptor> parameters, Map<String, MessageMetadataType> routeInputMessageTypes) {
        super(parameters);
        this.routeInputMessageTypes = Collections.unmodifiableMap(routeInputMessageTypes);
    }

    public static RouterInputMetadataDescriptorBuilder builder() {
        return new RouterInputMetadataDescriptorBuilder();
    }

    public Map<String, MessageMetadataType> getRouteInputMessageTypes() {
        return this.routeInputMessageTypes;
    }

    public static final class RouterInputMetadataDescriptorBuilder
    extends BaseInputMetadataDescriptorBuilder<RouterInputMetadataDescriptor, RouterInputMetadataDescriptorBuilder> {
        private final Map<String, MessageMetadataType> routeInputMessageTypes = new HashMap<String, MessageMetadataType>();

        public RouterInputMetadataDescriptorBuilder withRouteInputMessageType(String routeName, MessageMetadataType routeInputMessageType) {
            Preconditions.checkArgument(StringUtils.isBlank((CharSequence)routeName), "routeName cannot be null or blank");
            Preconditions.checkArgument(routeInputMessageType != null, "routeInputMessageType cannot be null");
            this.routeInputMessageTypes.put(routeName, routeInputMessageType);
            return this;
        }

        public RouterInputMetadataDescriptorBuilder withRoutesInputMessageTypes(Map<String, MessageMetadataType> routesInputTypes) {
            this.routeInputMessageTypes.putAll(routesInputTypes);
            return this;
        }

        @Override
        public RouterInputMetadataDescriptor build() {
            Preconditions.checkArgument(!this.routeInputMessageTypes.isEmpty(), "routeInputMessageTypes cannot be empty");
            return new RouterInputMetadataDescriptor(this.parameters, this.routeInputMessageTypes);
        }
    }
}

