/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.serialization.impl.gson.adapter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.serialization.impl.gson.adapter.ElementDeclarationSerializationUtils;
import org.mule.runtime.app.declaration.serialization.impl.gson.adapter.ParameterValueTypeAdapter;

public class ParameterElementDeclarationTypeAdapter
extends TypeAdapter<ParameterElementDeclaration> {
    private final Gson delegate = new GsonBuilder().registerTypeAdapter(ParameterValue.class, (Object)new ParameterValueTypeAdapter()).create();

    public void write(JsonWriter out, ParameterElementDeclaration parameter) throws IOException {
        if (parameter == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name").value(parameter.getName());
        ElementDeclarationSerializationUtils.populateMetadataAwareObject(this.delegate, out, parameter);
        out.name("value").jsonValue(this.delegate.toJson((Object)parameter.getValue(), ParameterValue.class));
        out.endObject();
    }

    public ParameterElementDeclaration read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementName = jsonObject.get("name");
            JsonElement elementValue = jsonObject.get("value");
            if (elementName != null && elementValue != null) {
                ParameterElementDeclaration declaration = new ParameterElementDeclaration();
                declaration.setName(elementName.getAsString());
                declaration.setValue((ParameterValue)this.delegate.fromJson(elementValue, ParameterValue.class));
                Map properties = (Map)this.delegate.fromJson(jsonObject.get("metadataProperties"), new TypeToken<Map<String, Serializable>>(){}.getType());
                properties.forEach(declaration::addMetadataProperty);
                return declaration;
            }
        }
        return null;
    }
}

