/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MuleCustomEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleCustomEntityResolver.class);
    private final ClassLoader deploymentClassLoader;
    private final ClassLoader muleImplementationsLoader = MuleImplementationLoaderUtils.getMuleImplementationsLoader();
    private final Map<String, String> muleSchemaMappings;
    private final Map<String, String> appPluginsSchemaMappings;

    public MuleCustomEntityResolver(ClassLoader deploymentClassLoader) {
        this.deploymentClassLoader = deploymentClassLoader;
        SchemaMappingsUtils schemaMappingsUtils = SchemaMappingsUtils.getFor(this.muleImplementationsLoader);
        this.muleSchemaMappings = this.getMuleSchemaMappings(schemaMappingsUtils);
        this.appPluginsSchemaMappings = this.getAppPluginsSchemaMappings(schemaMappingsUtils);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null) {
            InputSource source = MuleCustomEntityResolver.resolveEntityInClassloader(this.muleSchemaMappings, publicId, systemId, this.muleImplementationsLoader);
            if (source == null) {
                source = MuleCustomEntityResolver.resolveEntityInClassloader(this.appPluginsSchemaMappings, publicId, systemId, this.deploymentClassLoader);
            }
            return source;
        }
        return null;
    }

    private static InputSource resolveEntityInClassloader(Map<String, String> schemaMappings, String publicId, String systemId, ClassLoader cl) {
        String resourceLocation = schemaMappings.get(systemId);
        if (resourceLocation != null) {
            URL resource = cl.getResource(resourceLocation);
            if (resource == null) {
                LOGGER.debug("Couldn't find XML schema [" + systemId + "]: " + resourceLocation);
                return null;
            }
            try {
                InputStream is = IOUtils.getInputStreamWithCacheControl(resource);
                InputSource source = new InputSource(is);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
                }
                return source;
            }
            catch (IOException e) {
                LOGGER.warn("Error resolving entity [" + systemId + "]: " + resourceLocation, (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, String> getMuleSchemaMappings(SchemaMappingsUtils schemaMappingsUtils) {
        Map<String, String> schemaMappings = schemaMappingsUtils.getMuleSchemasMappings();
        Map<String, String> springMappings = schemaMappingsUtils.getSpringSchemasMappings();
        schemaMappings.putAll(springMappings);
        return schemaMappings;
    }

    private ClassLoader getClassLoaderToUse(ClassLoader classLoader) {
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = this.getDefaultClassLoader();
        }
        return classLoaderToUse;
    }

    private ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = this.muleImplementationsLoader) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private Map<String, String> getAppPluginsSchemaMappings(SchemaMappingsUtils schemaMappingsUtils) {
        return schemaMappingsUtils.getSchemaMappings("META-INF/mule.schemas", () -> this.getClassLoaderToUse(this.deploymentClassLoader));
    }
}

